/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.tasks;

import com.dbeaver.ee.tasks.ShellTaskSettings;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProcessDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.DBRShellCommand;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskHandler;
import org.jkiss.dbeaver.model.task.DBTTaskRunStatus;
import org.jkiss.utils.CommonUtils;

public class ShellTaskHandler
implements DBTTaskHandler {
    @NotNull
    public DBTTaskRunStatus executeTask(@NotNull DBRRunnableContext runnableContext, @NotNull DBTTask task, @NotNull Locale locale, final @NotNull Log log, final @NotNull PrintStream logStream, @NotNull DBTTaskExecutionListener listener) throws DBException {
        Exception error;
        DBTTaskRunStatus result;
        ShellTaskSettings settings;
        block10: {
            settings = new ShellTaskSettings();
            settings.loadConfiguration(task.getProperties());
            DBRShellCommand command = new DBRShellCommand(settings.getCommand());
            if (settings.getProcessTimeoutMs() != null) {
                command.setWaitProcessFinish(true);
                command.setWaitProcessTimeoutMs(settings.getProcessTimeoutMs().intValue());
            }
            if (settings.getPauseAfterExecuteMs() != null) {
                command.setPauseAfterExecute(settings.getPauseAfterExecuteMs().intValue());
            }
            if (settings.getWorkingDirectory() != null) {
                command.setWorkingDirectory(settings.getWorkingDirectory());
            }
            final DBRProcessDescriptor descriptor = new DBRProcessDescriptor(command);
            result = new DBTTaskRunStatus();
            error = null;
            listener.taskStarted(task);
            try {
                try {
                    descriptor.execute();
                    if (descriptor.isRunning()) {
                        new AbstractJob(String.valueOf(descriptor.getName()) + ": output reader"){

                            protected IStatus run(DBRProgressMonitor monitor) {
                                try {
                                    Log.setLogWriter((OutputStream)logStream);
                                    String output = descriptor.dumpOutput();
                                    String errors = descriptor.dumpErrors();
                                    if (CommonUtils.isNotEmpty((String)output)) {
                                        log.debug((Object)("Standard output:\n" + output + "\n"));
                                    }
                                    if (CommonUtils.isNotEmpty((String)errors)) {
                                        log.debug((Object)("Standard errors:\n" + errors + "\n"));
                                    }
                                }
                                finally {
                                    Log.setLogWriter(null);
                                }
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                    }
                    if (command.isWaitProcessFinish()) {
                        int code = command.getWaitProcessTimeoutMs() >= 0 ? descriptor.waitFor(command.getWaitProcessTimeoutMs()) : descriptor.waitFor();
                        result.setResultMessage("Exit code: " + code);
                    }
                }
                catch (Exception e) {
                    error = e;
                    Log.setLogWriter(null);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                Log.setLogWriter(null);
                throw throwable;
            }
            Log.setLogWriter(null);
        }
        listener.taskFinished(task, null, (Throwable)error, (Object)settings);
        return result;
    }
}

