/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.tasks;

import com.dbeaver.ee.tasks.CompositeTaskHandler;
import com.dbeaver.ee.tasks.CompositeTaskSettings;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskHandler;
import org.jkiss.dbeaver.model.task.DBTTaskRunStatus;
import org.jkiss.dbeaver.model.task.DBTaskUtils;

class CompositeTaskExecutor {
    @NotNull
    private final List<String> tasksStatistics = new ArrayList<String>();
    private final DBTTaskExecutionListener parentListener;
    @NotNull
    private DBRRunnableContext runnableContext;
    @NotNull
    private DBTTask task;
    @NotNull
    private Locale locale;
    @NotNull
    private Log log;
    @NotNull
    private PrintStream logStream;
    @NotNull
    DBTTaskExecutionListener listener;
    private Throwable lastTaskError;
    private CompositeTaskSettings settings;

    CompositeTaskExecutor(@NotNull DBRRunnableContext runnableContext, @NotNull DBTTask task, @NotNull Locale locale, @NotNull Log log, @NotNull PrintStream logStream, final @NotNull DBTTaskExecutionListener tl) {
        this.runnableContext = runnableContext;
        this.task = task;
        this.locale = locale;
        this.log = log;
        this.logStream = logStream;
        this.parentListener = tl;
        this.listener = new DBTTaskExecutionListener(){

            public void taskStarted(@NotNull @Nullable DBTTask task) {
            }

            public void taskFinished(@Nullable DBTTask task, @Nullable Object result, @Nullable Throwable error, @Nullable Object settings) {
                if (CompositeTaskExecutor.this.settings.isAllNotifications()) {
                    tl.subTaskFinished(task, error, settings);
                }
                CompositeTaskExecutor.this.lastTaskError = error;
            }

            public void subTaskFinished(@Nullable DBTTask task, @Nullable Throwable error, @Nullable Object settings) {
                if (CompositeTaskExecutor.this.settings.isAllNotifications()) {
                    tl.subTaskFinished(task, error, settings);
                }
            }
        };
    }

    DBTTaskRunStatus executeWithSettings(CompositeTaskSettings settings) throws DBException {
        this.parentListener.taskStarted(this.task);
        this.settings = settings;
        this.log.debug((Object)"Composite task execute");
        Throwable error = null;
        try {
            this.runnableContext.run(true, true, monitor -> {
                try {
                    this.runCompositeTask(monitor, settings);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            error = e.getTargetException();
        }
        catch (InterruptedException interruptedException) {
            this.log.debug((Object)"Task canceled");
        }
        if (error != null) {
            this.log.error((Object)error);
        }
        this.parentListener.taskFinished(this.task, null, error, (Object)settings);
        this.log.debug((Object)"Composite task execute completed");
        DBTTaskRunStatus resultStatus = new DBTTaskRunStatus();
        resultStatus.setResultMessage(String.join((CharSequence)" ", this.tasksStatistics));
        return resultStatus;
    }

    private void runCompositeTask(DBRProgressMonitor monitor, CompositeTaskSettings settings) throws DBException, InterruptedException {
        List<CompositeTaskSettings.TaskReference> taskList = settings.getTasks();
        DBTaskUtils.confirmTaskOrThrow((DBTTask)this.task, (Log)this.log, (PrintStream)this.logStream, (DBTaskUtils.TaskConfirmationsCollector)new NestedConfirmationMessagesCollector());
        monitor.beginTask("Execute nested tasks", taskList.size());
        for (CompositeTaskSettings.TaskReference tr : taskList) {
            try {
                this.runTask(monitor, tr);
                if (this.lastTaskError != null) {
                    throw new DBException("Sub task '" + tr.getTask().getName() + "' failed");
                }
            }
            catch (DBException e) {
                if (!settings.isIgnoreErrors() && !tr.isIgnoreErrors()) {
                    throw e;
                }
                this.log.error((Object)e);
            }
            monitor.worked(1);
        }
        monitor.done();
    }

    private void runTask(DBRProgressMonitor monitor, CompositeTaskSettings.TaskReference taskReference) throws DBException {
        monitor.subTask("Run task " + taskReference.getTask().getName());
        DBTTaskHandler handler = taskReference.getTask().getType().createHandler();
        DBTTaskRunStatus runStatus = handler.executeTask(this.runnableContext, taskReference.getTask(), this.locale, this.log, this.logStream, this.listener);
        this.tasksStatistics.add(String.format("'%s': %s; \n", taskReference.getTask().getName(), runStatus.getResultMessage()));
    }

    private class NestedConfirmationMessagesCollector
    implements DBTaskUtils.TaskConfirmationsCollector {
        private NestedConfirmationMessagesCollector() {
        }

        public boolean collect(StringBuilder messageBuilder, DBTTask task) {
            boolean confirmationRequired = false;
            if (task.getType().getHandlerClass().equals(CompositeTaskHandler.class)) {
                CompositeTaskSettings settings = new CompositeTaskSettings();
                settings.loadConfiguration(CompositeTaskExecutor.this.runnableContext, task.getProperties());
                for (CompositeTaskSettings.TaskReference tr : settings.getTasks()) {
                    confirmationRequired |= DBTaskUtils.collectConfirmationMessages((StringBuilder)messageBuilder, (DBTTask)tr.getTask(), (DBTaskUtils.TaskConfirmationsCollector)this);
                }
            }
            return confirmationRequired;
        }
    }
}

