/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.edb.model;

import com.dbeaver.db.edb.model.EDBSchema;
import java.sql.ResultSet;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreScriptObjectExt;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSPackage;

public class EDBPackage
implements DBSPackage,
DBPScriptObject,
PostgreScriptObjectExt {
    private EDBSchema edbSchema;
    private String name;
    private Long oid;
    private String source;
    private String description;

    public EDBPackage(@NotNull EDBSchema edbSchema, @NotNull JDBCResultSet dbResult) {
        this.edbSchema = edbSchema;
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"pkgname");
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.source = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"pkgheadsrc");
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"description");
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getSchema(), this});
    }

    private PostgreDatabase getDatabase() {
        return this.edbSchema.getDatabase();
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.edbSchema;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.edbSchema.getDataSource();
    }

    @NotNull
    public EDBSchema getSchema() {
        return this.edbSchema;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public Long getOid() {
        return this.oid;
    }

    @Property(viewable=true, updatable=true, length=PropertyLength.MULTILINE, order=10)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isPersisted() {
        return true;
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) {
        return this.source;
    }

    public void setObjectDefinitionText(String sourceText) {
    }
}

