/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.commands;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import net.ucanaccess.commands.ICommand;
import net.ucanaccess.commands.IFeedbackAction;
import net.ucanaccess.converters.Persist2Jet;
import net.ucanaccess.jdbc.UcanaccessSQLException;

public class AddColumnCommand
implements ICommand {
    private String execId;
    private String tableName;
    private String[] types;
    private String[] defaults;
    private Boolean[] notNulls;
    private Map<String, String> columnMap;
    private String columnName;

    public AddColumnCommand(String tableName, String columnName, String execId, Map<String, String> columnMap, String[] types, String[] defaults, Boolean[] notNulls) {
        this.tableName = tableName;
        this.columnName = columnName;
        this.types = types;
        this.defaults = defaults;
        this.notNulls = notNulls;
        this.columnMap = columnMap;
        this.execId = execId;
    }

    @Override
    public String getExecId() {
        return this.execId;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public ICommand.TYPES getType() {
        return ICommand.TYPES.DDL;
    }

    @Override
    public IFeedbackAction persist() throws SQLException {
        try {
            Persist2Jet p2a = new Persist2Jet();
            p2a.addColumn(this.tableName, this.columnName, this.columnMap, this.types, this.defaults, this.notNulls);
        }
        catch (IOException e) {
            throw new UcanaccessSQLException(e);
        }
        return null;
    }

    @Override
    public IFeedbackAction rollback() throws SQLException {
        return null;
    }
}

