/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.registry;

import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudUtils;
import com.dbeaver.cloud.model.CPCloudZone;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import com.dbeaver.cloud.registry.CloudProviderRegistry;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceOrigin;
import org.jkiss.dbeaver.model.DBPDataSourceOriginProvider;
import org.jkiss.dbeaver.model.DBPExternalConfiguration;
import org.jkiss.utils.CommonUtils;

public class DataSourceOriginProviderCloud
implements DBPDataSourceOriginProvider {
    private static final Log log = Log.getLog(DataSourceOriginProviderCloud.class);

    @NotNull
    public DBPDataSourceOrigin getOrigin(@NotNull Map<String, Object> dsConfiguration, @Nullable DBPExternalConfiguration externalConfiguration) throws DBException {
        String providerId = CommonUtils.toString((Object)dsConfiguration.get("cloud-provider"));
        CloudProviderDescriptor provider = CloudProviderRegistry.getInstance().getCloudProvider(providerId);
        if (provider == null) {
            throw new DBException("Cloud provider '" + providerId + "' not found");
        }
        String cloudId = CommonUtils.toString((Object)dsConfiguration.get("cloud-id"));
        CPCloud<?, ?> cloud = CPCloudUtils.getCloud(provider, cloudId, externalConfiguration);
        if (cloud != null) {
            String zoneId = CommonUtils.toString((Object)dsConfiguration.get("cloud-zone-id"));
            CPCloudZone zone = CPCloudUtils.findZone(cloud, zoneId);
            return provider.getInstance().createDataSourceOrigin(cloud, zone, dsConfiguration);
        }
        throw new DBException("Cloud '" + cloudId + "' not found");
    }
}

