/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.registry;

import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudZone;
import com.dbeaver.cloud.registry.CPCloudConfigurationProvider;
import com.dbeaver.cloud.registry.CPCloudConfigurationProviderCustom;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import com.dbeaver.cloud.registry.CloudProviderRegistry;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceOriginExternal;
import org.jkiss.dbeaver.model.DBPExternalConfiguration;
import org.jkiss.dbeaver.model.DBPImage;

public abstract class DataSourceOriginCloud<CLOUD extends CPCloud<ZONE, ?>, ZONE extends CPCloudZone>
implements DBPDataSourceOriginExternal {
    public static final String ORIGIN_TYPE = "cloud";
    public static final String PROPERTY_CLOUD_PROVIDER = "cloud-provider";
    public static final String PROPERTY_CLOUD_ID = "cloud-id";
    public static final String PROPERTY_CLOUD_ZONE_ID = "cloud-zone-id";
    private final CloudProviderDescriptor provider;
    protected final CLOUD cloud;
    protected final ZONE zone;

    public DataSourceOriginCloud(@NotNull CloudProviderDescriptor provider, @NotNull CLOUD cloud, @Nullable ZONE zone) {
        this.provider = provider;
        this.cloud = cloud;
        this.zone = zone;
    }

    public CloudProviderDescriptor getCloudProvider() {
        return this.provider;
    }

    public CLOUD getCloud() {
        return this.cloud;
    }

    public ZONE getZone() {
        return this.zone;
    }

    public abstract String getResourceId();

    @NotNull
    public String getType() {
        return ORIGIN_TYPE;
    }

    @Nullable
    public String getSubType() {
        return this.provider.getId();
    }

    @NotNull
    public String getDisplayName() {
        return this.cloud.getName();
    }

    @Nullable
    public DBPImage getIcon() {
        return this.provider.getIcon();
    }

    public boolean isDynamic() {
        return true;
    }

    @NotNull
    public Map<String, Object> getDataSourceConfiguration() {
        LinkedHashMap<String, Object> config = new LinkedHashMap<String, Object>();
        config.put(PROPERTY_CLOUD_PROVIDER, this.provider.getId());
        config.put(PROPERTY_CLOUD_ID, this.cloud.getCloudId());
        if (this.zone != null) {
            config.put(PROPERTY_CLOUD_ZONE_ID, this.zone.getZoneId());
        }
        return config;
    }

    @Nullable
    public DBPExternalConfiguration getExternalConfiguration() {
        CPCloudConfigurationProvider configurationProvider = CloudProviderRegistry.getInstance().getConfigurationProvider(this.provider.getId());
        if (!(configurationProvider instanceof CPCloudConfigurationProviderCustom)) {
            return null;
        }
        Map<String, Object> properties = ((CPCloudConfigurationProviderCustom)configurationProvider).serializeCloudConfiguration(this.cloud.getCloudConfiguration());
        return new DBPExternalConfiguration(this.cloud.getCloudId(), properties);
    }

    public String toString() {
        return String.valueOf(this.getType()) + "." + this.getSubType() + ":" + this.getResourceId();
    }
}

