/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.model.navigator;

import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudExplorer;
import com.dbeaver.cloud.model.CPCloudSession;
import com.dbeaver.cloud.model.CPCloudZone;
import com.dbeaver.cloud.model.navigator.DBNCloudFolderNode;
import com.dbeaver.cloud.model.navigator.DBNCloudServiceNode;
import com.dbeaver.cloud.model.services.CPDatabaseFolder;
import com.dbeaver.cloud.registry.CloudDatabaseServiceDescriptor;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import java.util.ArrayList;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.navigator.DBNLazyNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.ArrayUtils;

public class DBNCloudNode
extends DBNNode
implements DBNLazyNode {
    private static final Log log = Log.getLog(DBNCloudNode.class);
    private final CloudProviderDescriptor provider;
    private final CPCloud<CPCloudZone, CPCloudSession<CPCloudZone>> cloud;
    private CPCloudExplorer<?> cloudExplorer;
    private volatile DBNCloudFolderNode[] cloudFolders;
    private volatile DBNCloudServiceNode[] databaseServiceNodes;

    DBNCloudNode(DBNNode parentNode, CloudProviderDescriptor cpDescriptor, CPCloud<CPCloudZone, CPCloudSession<CPCloudZone>> cloud) {
        super(parentNode);
        this.provider = cpDescriptor;
        this.cloud = cloud;
    }

    DBPDataSourceRegistry getDataSourceRegistry() {
        return this.getProjectNode().getDatabases().getDataSourceRegistry();
    }

    private DBNProject getProjectNode() {
        DBNNode parent = this.parentNode;
        while (parent != null) {
            if (parent instanceof DBNProject) {
                return (DBNProject)parent;
            }
            parent = parent.getParentNode();
        }
        throw new IllegalStateException("No parent project node for cloud node " + (Object)((Object)this));
    }

    public CPCloud<?, ?> getCloud() {
        return this.cloud;
    }

    public String getNodeType() {
        return "cloud";
    }

    public String getNodeName() {
        return this.cloud.getName();
    }

    public String getNodeDescription() {
        return this.provider.getDescription();
    }

    public DBPImage getNodeIcon() {
        return this.provider.getIcon();
    }

    protected boolean allowsChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBNNode[] getChildren(DBRProgressMonitor monitor) throws DBException {
        DBNCloudNode dBNCloudNode;
        if (this.cloudFolders == null) {
            dBNCloudNode = this;
            synchronized (dBNCloudNode) {
                Object[] folders = this.getCloudExplorer(monitor).getRootFolders(monitor);
                if (!ArrayUtils.isEmpty((Object[])folders)) {
                    this.cloudFolders = new DBNCloudFolderNode[folders.length];
                    int i = 0;
                    while (i < folders.length) {
                        this.cloudFolders[i] = new DBNCloudFolderNode(this, (CPDatabaseFolder)folders[i]);
                        ++i;
                    }
                } else {
                    this.cloudFolders = new DBNCloudFolderNode[0];
                }
            }
        }
        if (this.cloudFolders.length > 0) {
            return this.cloudFolders;
        }
        if (this.databaseServiceNodes == null) {
            dBNCloudNode = this;
            synchronized (dBNCloudNode) {
                if (this.databaseServiceNodes == null) {
                    this.databaseServiceNodes = this.readCloudServices(monitor, this);
                }
            }
        }
        return this.databaseServiceNodes;
    }

    DBNCloudServiceNode[] readCloudServices(DBRProgressMonitor monitor, DBNNode parentNode) throws DBException {
        ArrayList<DBNCloudServiceNode> serviceNodes = new ArrayList<DBNCloudServiceNode>();
        for (CloudDatabaseServiceDescriptor databaseService : this.provider.getDatabaseServices()) {
            if (!this.cloud.isDatabaseServiceSupported(databaseService.getId())) continue;
            DBNCloudServiceNode serviceNode = new DBNCloudServiceNode(parentNode, databaseService);
            serviceNodes.add(serviceNode);
        }
        return serviceNodes.toArray(new DBNCloudServiceNode[0]);
    }

    CPCloudExplorer<?> getCloudExplorer(DBRProgressMonitor monitor) throws DBException {
        if (this.cloudExplorer != null) {
            return this.cloudExplorer;
        }
        this.cloudExplorer = this.cloud.createExplorer(monitor, this.getCloudSession(monitor));
        return this.cloudExplorer;
    }

    private CPCloudSession getCloudSession(DBRProgressMonitor monitor) throws DBException {
        SMSession cloudSession = this.getModel().getModelAuthContext().getSpaceSession(monitor, this.cloud, true);
        if (cloudSession instanceof CPCloudSession) {
            return (CPCloudSession)cloudSession;
        }
        throw new DBException(this.cloud.getName() + " cloud not initialized. You must authorize with " + this.cloud.getCloudId() + " credentials.");
    }

    public String getNodeItemPath() {
        return String.valueOf(this.getParentNode().getNodeItemPath()) + "/" + this.getNodeName();
    }

    public DBNNode refreshNode(DBRProgressMonitor monitor, Object source) throws DBException {
        this.resetServicesCache();
        return this;
    }

    public void refreshCloudConfiguration(DBRProgressMonitor monitor) {
        if (this.cloudExplorer != null) {
            try {
                CPCloudSession cloudSession = this.getCloudSession(monitor);
                this.cloudExplorer.refreshSession(cloudSession);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    public void resetServicesCache() {
        if (this.databaseServiceNodes != null) {
            DBNCloudServiceNode[] dBNCloudServiceNodeArray = this.databaseServiceNodes;
            int n = this.databaseServiceNodes.length;
            int n2 = 0;
            while (n2 < n) {
                DBNCloudServiceNode node = dBNCloudServiceNodeArray[n2];
                DBNModel.disposeNode((DBNNode)node, (boolean)true);
                ++n2;
            }
            this.databaseServiceNodes = null;
        }
    }

    public boolean needsInitialization() {
        return this.cloudFolders == null;
    }

    public String toString() {
        return this.cloud.toString();
    }
}

