/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.model.navigator;

import com.dbeaver.cloud.model.navigator.DBNCloudItemNode;
import com.dbeaver.cloud.model.navigator.DBNCloudServiceNode;
import com.dbeaver.cloud.model.services.CPDatabaseFolder;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObjectWithDescription;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.ArrayUtils;

public class DBNCloudFolderNode
extends DBNCloudItemNode {
    private static final Log log = Log.getLog(DBNCloudFolderNode.class);
    private final CPDatabaseFolder folder;
    private volatile DBNCloudFolderNode[] childFolders;
    private volatile DBNCloudServiceNode[] databaseServices;

    DBNCloudFolderNode(DBNNode parent, CPDatabaseFolder folder) {
        super(parent);
        this.folder = folder;
    }

    public CPDatabaseFolder getFolder() {
        return this.folder;
    }

    public String getNodeType() {
        return "cloudFolder";
    }

    public String getNodeName() {
        return this.folder.getFolderName();
    }

    public String getNodeDescription() {
        return this.folder instanceof DBPObjectWithDescription ? ((DBPObjectWithDescription)this.folder).getDescription() : null;
    }

    public DBPImage getNodeIcon() {
        return DBIcon.TREE_FOLDER;
    }

    protected boolean allowsChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBNNode[] getChildren(DBRProgressMonitor monitor) throws DBException {
        if (this.folder.hasChildFolders()) {
            if (this.childFolders == null) {
                DBNCloudFolderNode dBNCloudFolderNode = this;
                synchronized (dBNCloudFolderNode) {
                    Object[] folders = this.folder.getChildFolders(monitor);
                    if (!ArrayUtils.isEmpty((Object[])folders)) {
                        this.childFolders = new DBNCloudFolderNode[folders.length];
                        int i = 0;
                        while (i < folders.length) {
                            this.childFolders[i] = new DBNCloudFolderNode(this, (CPDatabaseFolder)folders[i]);
                            ++i;
                        }
                    } else {
                        this.childFolders = new DBNCloudFolderNode[0];
                    }
                }
            }
            return this.childFolders;
        }
        if (this.databaseServices == null) {
            DBNCloudFolderNode dBNCloudFolderNode = this;
            synchronized (dBNCloudFolderNode) {
                if (this.databaseServices == null) {
                    this.databaseServices = this.getCloudNode().readCloudServices(monitor, this);
                }
            }
        }
        return this.databaseServices;
    }

    @Override
    public String getNodeItemPath() {
        return String.valueOf(this.getParentNode().getNodeItemPath()) + "/" + this.folder.getFolderName();
    }

    @Override
    public String toString() {
        return this.folder.toString();
    }
}

