/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2dl.AbstractLayout;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.Locator;
import org.eclipse.draw2dl.geometry.Dimension;

public class DelegatingLayout
extends AbstractLayout {
    private Map<IFigure, Object> constraints = new HashMap<IFigure, Object>();

    @Override
    protected Dimension calculatePreferredSize(IFigure parent, int wHint, int hHint) {
        List<IFigure> children = parent.getChildren();
        Dimension d = new Dimension();
        for (IFigure child : children) {
            d.union(child.getPreferredSize());
        }
        return d;
    }

    @Override
    public Object getConstraint(IFigure child) {
        return this.constraints.get(child);
    }

    @Override
    public void layout(IFigure parent) {
        List<IFigure> children = parent.getChildren();
        for (IFigure child : children) {
            Locator locator = (Locator)this.constraints.get(child);
            if (locator == null) continue;
            locator.relocate(child);
        }
    }

    @Override
    public void remove(IFigure child) {
        this.constraints.remove(child);
    }

    @Override
    public void setConstraint(IFigure figure, Object constraint) {
        super.setConstraint(figure, constraint);
        if (constraint != null) {
            this.constraints.put(figure, constraint);
        }
    }
}

