/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.custom.athena.jdbc;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.simba.athena.amazonaws.auth.AWSStaticCredentialsProvider;
import com.simba.athena.amazonaws.auth.BasicAWSCredentials;
import com.simba.athena.amazonaws.auth.BasicSessionCredentials;

public class CustomIAMRoleAssumptionCredentialsProvider
implements AWSCredentialsProvider {
    private final AWSCredentials credentials;
    private final String roleArn;
    private AWSCredentials assumedCredentials;
    private AWSSecurityTokenService stsClient;

    public CustomIAMRoleAssumptionCredentialsProvider(String accessId, String secretKey, String roleArn) {
        this.credentials = new BasicAWSCredentials(accessId, secretKey);
        this.roleArn = roleArn;
        this.stsClient = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider(this.credentials))).build();
        this.refresh();
    }

    public AWSCredentials getCredentials() {
        return this.assumedCredentials;
    }

    public void refresh() {
        AssumeRoleResult result = this.stsClient.assumeRole(new AssumeRoleRequest().withRoleArn(this.roleArn).withRoleSessionName("athenajdbc"));
        this.assumedCredentials = this.getCredentialsFromAssumedRoleResult(result);
    }

    protected AWSCredentials getCredentialsFromAssumedRoleResult(AssumeRoleResult result) {
        return new BasicSessionCredentials(result.getCredentials().getAccessKeyId(), result.getCredentials().getSecretAccessKey(), result.getCredentials().getSessionToken());
    }
}

