/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.impl.liquibase;

import liquibase.database.Database;
import liquibase.snapshot.SnapshotListener;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class LBSnapshotListener
implements SnapshotListener {
    private final String name;
    private final DBRProgressMonitor monitor;

    LBSnapshotListener(String name, DBRProgressMonitor monitor) {
        this.name = name;
        this.monitor = monitor;
    }

    private String getSchema(DatabaseObject example) {
        Schema schema = example.getSchema();
        if (schema == null) {
            return "";
        }
        return schema.getName() == null ? "" : String.valueOf(schema.getName()) + ".";
    }

    public void willSnapshot(DatabaseObject example, Database database) {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new RuntimeException("Comparison report generating stopped by user.");
        }
        if (example != null && example.getName() != null && this.monitor != null) {
            this.monitor.subTask("[" + this.name + "] Prepare snapshot for " + this.getSchema(example) + example.getName());
        }
    }

    public void finishedSnapshot(DatabaseObject example, DatabaseObject snapshot, Database database) {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new RuntimeException("Comparison report generating stopped by user.");
        }
        if (example != null && example.getName() != null && this.monitor != null) {
            this.monitor.subTask("[" + this.name + "] " + this.getSchema(example) + example.getName() + " done.");
        }
    }
}

