/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.impl.liquibase;

import com.dbeaver.ee.scmp.impl.liquibase.LBObjectDataType;
import com.dbeaver.ee.scmp.model.CMPException;
import com.dbeaver.ee.scmp.model.CMPOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.ObjectChangeFilter;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Schema;
import liquibase.structure.core.View;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.utils.CommonUtils;

public class LBObjectChangeFilter
implements ObjectChangeFilter {
    private final CMPOptions options;
    private final DBPDataSource sqlDataSource;
    private final Database lbDatabase;
    private final Map<String, List<DBSObject>> inputObjects = new HashMap<String, List<DBSObject>>();
    private final Map<String, DBSObject> outputObjects = new HashMap<String, DBSObject>();

    public LBObjectChangeFilter(CMPOptions options, Database lbDatabase) throws CMPException {
        String containerName;
        DBPDataSource dataSource;
        this.options = options;
        this.sqlDataSource = dataSource = options.getSourceInput().getDataSourceContainer().getDataSource();
        this.lbDatabase = lbDatabase;
        for (DBSObject object : options.getSourceInput().getInputObjects()) {
            if (object instanceof DBSObjectContainer || object instanceof DBPDataSourceContainer) {
                containerName = "";
                if (object instanceof DBSObjectContainer) {
                    containerName = this.getContainerName((DBSObjectContainer)object);
                }
                this.inputObjects.computeIfAbsent(containerName, dbsObjectContainer -> new ArrayList());
                continue;
            }
            if (object == null) continue;
            DBSObjectContainer objectContainer = (DBSObjectContainer)DBUtils.getParentOfType(DBSObjectContainer.class, (DBSObject)object);
            List objects = this.inputObjects.computeIfAbsent(this.getContainerName(objectContainer), dbsObjectContainer -> new ArrayList());
            objects.add(object);
        }
        if (options.getTargetInput() != null) {
            for (DBSObject object : options.getTargetInput().getInputObjects()) {
                if (!(object instanceof DBSObjectContainer) && !(object instanceof DBPDataSourceContainer)) continue;
                containerName = "";
                if (object instanceof DBSObjectContainer) {
                    containerName = this.getContainerName((DBSObjectContainer)object);
                }
                this.outputObjects.put(containerName, object);
            }
        }
    }

    private String getContainerName(DBSObjectContainer object) {
        if (object instanceof DBPDataSource) {
            return "";
        }
        ArrayList<String> fqNames = new ArrayList<String>();
        DBSObjectContainer co = object;
        while (co != null) {
            if (co instanceof DBPDataSource || co instanceof DBPDataSourceContainer) break;
            String objectName = DBUtils.getQuotedIdentifier((DBPDataSource)this.sqlDataSource, (String)co.getName(), (boolean)true, (boolean)true);
            fqNames.add(0, objectName);
            co = co.getParentObject();
        }
        return String.join((CharSequence)this.sqlDataSource.getSQLDialect().getCatalogSeparator(), fqNames);
    }

    private String getContainerName(DatabaseObject object) {
        Catalog catalog;
        Schema schema = object.getSchema();
        Catalog catalog2 = catalog = schema == null ? null : schema.getCatalog();
        if (schema == null && catalog == null) {
            return "";
        }
        ArrayList<String> fqNames = new ArrayList<String>();
        if (catalog != null && catalog.getName() != null && this.lbDatabase.supportsCatalogs()) {
            fqNames.add(DBUtils.getQuotedIdentifier((DBPDataSource)this.sqlDataSource, (String)catalog.getName(), (boolean)true, (boolean)true));
        }
        if (schema != null && schema.getName() != null && this.lbDatabase.supportsSchemas()) {
            fqNames.add(DBUtils.getQuotedIdentifier((DBPDataSource)this.sqlDataSource, (String)schema.getName(), (boolean)true, (boolean)true));
        }
        return String.join((CharSequence)this.sqlDataSource.getSQLDialect().getCatalogSeparator(), fqNames);
    }

    private boolean containsObject(DatabaseObject object) {
        if (LBObjectDataType.isTableAttributes(object)) {
            if (object instanceof ForeignKey) {
                ForeignKey FK = (ForeignKey)object;
                return this.containsObject((DatabaseObject)FK.getForeignKeyTable());
            }
            DatabaseObject[] containingObjects = object.getContainingObjects();
            if (containingObjects != null && object.getContainingObjects().length != 0) {
                return this.containsObject(object.getContainingObjects()[0]);
            }
            return false;
        }
        String containerName = this.getContainerName(object);
        List<DBSObject> objectList = this.inputObjects.get(containerName);
        if (objectList == null) {
            DBSObject viewSchema;
            if (object instanceof View && this.lbDatabase instanceof OracleDatabase && (viewSchema = this.outputObjects.get(containerName)) != null) {
                return true;
            }
            DatabaseObject[] containingObjects = object.getContainingObjects();
            if (containingObjects != null) {
                DatabaseObject[] databaseObjectArray = containingObjects;
                int n = containingObjects.length;
                int n2 = 0;
                while (n2 < n) {
                    DatabaseObject co = databaseObjectArray[n2];
                    if (!this.containsObject(co)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            return false;
        }
        if (objectList.isEmpty()) {
            return true;
        }
        for (DBSObject incObject : objectList) {
            if (!CommonUtils.equalObjects((Object)incObject.getName(), (Object)object.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean includeMissing(DatabaseObject object, Database referenceDatabase, Database comparisionDatabase) {
        if (!this.options.isDoCreate()) {
            return false;
        }
        return this.containsObject(object);
    }

    public boolean includeUnexpected(DatabaseObject object, Database referenceDatabase, Database comparisionDatabase) {
        if (!this.options.isDoDrop()) {
            return false;
        }
        String targetContainerName = this.getContainerName(object);
        DBSObject outContainer = this.outputObjects.get(targetContainerName);
        if (outContainer == null) {
            return false;
        }
        DBSObjectContainer sourceContainer = this.options.getSourceContainer(outContainer.getName());
        if (sourceContainer == null) {
            return false;
        }
        String sourceContainerName = this.getContainerName(sourceContainer);
        List<DBSObject> sourceObjects = this.inputObjects.get(sourceContainerName);
        if (sourceObjects == null) {
            return false;
        }
        return sourceObjects.isEmpty();
    }

    public boolean includeChanged(DatabaseObject object, ObjectDifferences differences, Database referenceDatabase, Database comparisionDatabase) {
        if (!this.options.isDoChange()) {
            return false;
        }
        return this.containsObject(object);
    }

    public boolean include(DatabaseObject object) {
        return this.containsObject(object);
    }
}

