/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.impl.liquibase;

import com.dbeaver.ee.scmp.model.CMPOptions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class LBLogFileManager {
    File generateLogReport(DBRProgressMonitor monitor, CMPOptions options, String changeLog) throws IOException {
        monitor.beginTask("Generate log report", 5);
        monitor.subTask("Prepare log report file");
        File logFile = this.createLogFile(monitor, options);
        monitor.subTask("Generate log report");
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (FileOutputStream stream = new FileOutputStream(logFile);){
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, GeneralUtils.getDefaultFileEncoding());
                if (CommonUtils.isNotEmpty((String)changeLog)) {
                    writer.write(changeLog);
                } else {
                    writer.write("Log report file is empty. You can change the logging level in the preferences (Preferences -> Editors -> Schema Compare).");
                }
                ((Writer)writer).flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            monitor.done();
        }
        return logFile;
    }

    private File createLogFile(DBRProgressMonitor monitor, CMPOptions options) throws IOException {
        File tempFolder = DBWorkbench.getPlatform().getTempFolder(monitor, "scmp-diff-reports");
        return new File(tempFolder, "log-report-" + options.getLogLevel().name().toLowerCase(Locale.ENGLISH) + "-" + new SimpleDateFormat("yyyyMMddHHmmss").format(System.currentTimeMillis()) + ".log");
    }
}

