/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.netezza.database;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.CatalogAndSchema;
import liquibase.Scope;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.OfflineConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.ExecutorService;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;

public class NetezzaDatabase
extends AbstractJdbcDatabase {
    public static final String PRODUCT_NAME = "Netezza NPS";
    private String connectionSchemaName;
    private Set<String> reservedWords = new HashSet<String>();

    public NetezzaDatabase() {
        super.setCurrentDateTimeFunction("NOW()");
        this.unquotedObjectsAreUppercased = true;
        this.sequenceNextValueFunction = "NEXT VALUE FOR %s";
        this.unmodifiableDataTypes.addAll(Arrays.asList("int", "integer", "smallint", "bigint", "bool", "boolean", "bit", "byteint", "float", "interval", "real", "time", "date", "timestamp", "timestamp with time zone"));
        this.reservedWords.addAll(Arrays.asList("CURRENT_DB", "CURRENT_SID", "CURRENT_USERID", "CURRENT_USEROID", "CURRENT_CATALOG", "CURRENT_PATH", "CURRENT_SCHEMA", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_TX_PATH", "CURRENT_TX_SCHEMA", "CURRENT_USER", "DATE_PART", "DATE_TRUNC", "TIMEOFDAY", "ANALYZE", "COMMENT", "DECODE", "RESET", "DISTRIBUTE", "LOCK", "SHOW", "SYNONYM", "EXPRESS", "ONLINE", "RESET"));
    }

    public String getShortName() {
        return "netezza";
    }

    protected String getDefaultDatabaseProductName() {
        return PRODUCT_NAME;
    }

    public Integer getDefaultPort() {
        return 5480;
    }

    public int getPriority() {
        return 5;
    }

    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return PRODUCT_NAME.equalsIgnoreCase(conn.getDatabaseProductName());
    }

    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:netezza:")) {
            return "org.netezza.Driver";
        }
        return null;
    }

    public String getDefaultCatalogName() {
        return super.getDefaultCatalogName() == null ? null : super.getDefaultCatalogName().toUpperCase();
    }

    public String getDefaultSchemaName() {
        return super.getDefaultSchemaName() == null ? null : super.getDefaultSchemaName().toUpperCase();
    }

    public String getJdbcCatalogName(CatalogAndSchema schema) {
        return super.getJdbcCatalogName(schema) == null ? null : super.getJdbcCatalogName(schema).toUpperCase();
    }

    public String getJdbcSchemaName(CatalogAndSchema schema) {
        return super.getJdbcSchemaName(schema) == null ? null : super.getJdbcSchemaName(schema).toUpperCase();
    }

    public boolean supportsCatalogs() {
        return true;
    }

    public boolean supportsCatalogInObjectName(Class<? extends DatabaseObject> type) {
        return false;
    }

    public boolean supportsSequences() {
        return true;
    }

    public String getDatabaseChangeLogTableName() {
        return super.getDatabaseChangeLogTableName().toUpperCase();
    }

    public String getDatabaseChangeLogLockTableName() {
        return super.getDatabaseChangeLogLockTableName().toUpperCase();
    }

    public boolean supportsTablespaces() {
        return false;
    }

    public boolean supportsRestrictForeignKeys() {
        return true;
    }

    public boolean supportsSchemas() {
        return true;
    }

    protected String getConnectionSchemaName() {
        if (this.connectionSchemaName == null) {
            if (this.getConnection() == null || this.getConnection() instanceof OfflineConnection) {
                return "ADMIN";
            }
            try {
                String schemaName = (String)((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", (Database)this).queryForObject((SqlStatement)new RawSqlStatement("SELECT DEFSCHEMA FROM _V_DATABASE WHERE DATABASE='" + this.getConnection().getCatalog() + "'"), String.class);
                if (schemaName != null) {
                    this.connectionSchemaName = schemaName.trim();
                }
            }
            catch (Exception e) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Error getting connection schema", (Throwable)e);
            }
        }
        return this.connectionSchemaName;
    }
}

