/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.gef3;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.draw2dl.ScalableFigure;
import org.eclipse.draw2dl.Viewport;
import org.eclipse.draw2dl.geometry.Dimension;
import org.eclipse.gef3.editparts.ZoomManager;
import org.eclipse.gef3.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.graphiti.internal.pref.GFPreferences;
import org.eclipse.graphiti.ui.internal.editor.GFFigureCanvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class ZoomManagerWithAnimation
extends ZoomManager {
    ScrollingGraphicalViewer viewer = null;
    private static int totalSteps = 5;
    private AtomicBoolean isAnimating = new AtomicBoolean(false);

    public ZoomManagerWithAnimation(ScalableFigure pane, Viewport viewport, ScrollingGraphicalViewer viewer) {
        super(pane, viewport);
        this.viewer = viewer;
    }

    protected void primSetZoom(double zoom) {
        if (this.isAnimating.compareAndSet(false, true)) {
            double currentZoom = this.getZoom();
            this.zoomSqrt(currentZoom, zoom, totalSteps);
            super.primSetZoom(zoom);
            this.isAnimating.set(false);
        }
    }

    protected double getFitPageZoomLevel() {
        double zoomLevel = 1.0;
        if (this.viewer != null) {
            Control control = this.viewer.getControl();
            if (control instanceof GFFigureCanvas) {
                GFFigureCanvas gfFigureCanvas = (GFFigureCanvas)control;
                gfFigureCanvas.removeCornerPixels();
                zoomLevel = this.getFitXZoomLevel(2, gfFigureCanvas);
                gfFigureCanvas.setCornerPixels();
                return zoomLevel;
            }
            return super.getFitPageZoomLevel();
        }
        return super.getFitPageZoomLevel();
    }

    private void zoomSqrt(double currentZoom, double targetZoom, int totalSteps) {
        double currentZoom2 = Math.sqrt(currentZoom);
        double targetZoom2 = Math.sqrt(targetZoom);
        double delta = (targetZoom2 - currentZoom2) / (double)totalSteps;
        int i = 0;
        while (i < totalSteps) {
            super.primSetZoom((currentZoom2 += delta) * currentZoom2);
            this.stepPerformed();
            ++i;
        }
    }

    public void stepPerformed() {
        while (Display.getCurrent().readAndDispatch()) {
        }
    }

    public int getTotalSteps() {
        int totalSteps = GFPreferences.getInstance().getZoomAnimationSteps();
        return totalSteps;
    }

    protected double getFitWidthZoomLevel() {
        double zoomLevel = 1.0;
        if (this.viewer != null) {
            Control control = this.viewer.getControl();
            if (control instanceof GFFigureCanvas) {
                GFFigureCanvas gfFigureCanvas = (GFFigureCanvas)control;
                gfFigureCanvas.removeCornerPixels();
                zoomLevel = this.getFitXZoomLevel(0, gfFigureCanvas);
                gfFigureCanvas.setCornerPixels();
                return zoomLevel;
            }
            return super.getFitWidthZoomLevel();
        }
        return super.getFitWidthZoomLevel();
    }

    protected double getFitHeightZoomLevel() {
        double zoomLevel = 1.0;
        if (this.viewer != null) {
            Control control = this.viewer.getControl();
            if (control instanceof GFFigureCanvas) {
                GFFigureCanvas gfFigureCanvas = (GFFigureCanvas)control;
                gfFigureCanvas.removeCornerPixels();
                zoomLevel = this.getFitXZoomLevel(1, gfFigureCanvas);
                gfFigureCanvas.setCornerPixels();
                return zoomLevel;
            }
            return super.getFitHeightZoomLevel();
        }
        return super.getFitHeightZoomLevel();
    }

    private double getFitXZoomLevel(int which, GFFigureCanvas gfFigureCanvas) {
        Dimension available = this.getViewport().getClientArea().getSize();
        Dimension desired = gfFigureCanvas.getDiagramBoundsFromEditPartChildren().getSize();
        double scaleX = Math.min((double)available.width / (double)desired.width, this.getMaxZoom());
        double scaleY = Math.min((double)available.height / (double)desired.height, this.getMaxZoom());
        if (which == 0) {
            return scaleX;
        }
        if (which == 1) {
            return scaleY;
        }
        return Math.min(scaleX, scaleY);
    }
}

