/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.policy;

import java.util.List;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef3.GraphicalEditPart;
import org.eclipse.gef3.Request;
import org.eclipse.gef3.editpolicies.ResizableEditPolicy;
import org.eclipse.gef3.handles.AbstractHandle;
import org.eclipse.graphiti.features.IResizeConfiguration;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.policy.GFEditPolicyDelegate;
import org.eclipse.graphiti.ui.internal.util.draw2dl.GFHandleHelper;
import org.eclipse.graphiti.ui.internal.util.draw2dl.TransparentGhostFigure;

public class GFResizableEditPolicy
extends ResizableEditPolicy {
    private GFEditPolicyDelegate delegate;
    private IResizeShapeContext resizeShapeContext;

    public GFResizableEditPolicy(IConfigurationProviderInternal cfgProvider) {
        this.setDelegate(new GFEditPolicyDelegate(cfgProvider));
    }

    public GFResizableEditPolicy(IConfigurationProviderInternal configurationProvider, IResizeShapeContext resizeShapeContext) {
        this(configurationProvider);
        this.setResizeShapeContext(resizeShapeContext);
    }

    protected IFigure createDragSourceFeedbackFigure() {
        TransparentGhostFigure feedback = new TransparentGhostFigure(70);
        this.addFeedback((IFigure)feedback);
        return feedback;
    }

    protected List<?> createSelectionHandles() {
        boolean resizeAllowed = false;
        if (this.getResizeShapeContext() != null) {
            resizeAllowed = this.getResizeShapeFeature() != null && this.getResizeShapeFeature().canResizeShape(this.getResizeShapeContext());
        }
        GraphicalEditPart owner = (GraphicalEditPart)this.getHost();
        List<AbstractHandle> list = GFHandleHelper.createShapeHandles(owner, this.getConfigurationProvider(), this.getResizeDirections(), this.isDragAllowed(), resizeAllowed);
        return list;
    }

    public void eraseSourceFeedback(Request request) {
        List children = this.getFeedbackLayer().getChildren();
        for (IFigure child : children) {
            if (!(child instanceof TransparentGhostFigure)) continue;
            ((TransparentGhostFigure)child).dispose();
        }
        super.eraseSourceFeedback(request);
    }

    protected IConfigurationProviderInternal getConfigurationProvider() {
        return this.getDelegate().getConfigurationProvider();
    }

    private GFEditPolicyDelegate getDelegate() {
        return this.delegate;
    }

    public int getResizeDirections() {
        IResizeShapeFeature resizeShapeFeature;
        int ret = 0;
        if (this.getResizeShapeContext() != null && (resizeShapeFeature = this.getResizeShapeFeature()) != null) {
            IResizeConfiguration resizeConfiguration = resizeShapeFeature.getResizeConfiguration(this.getResizeShapeContext());
            if (resizeConfiguration.isHorizontalResizeAllowed()) {
                ret |= 0x18;
            }
            if (resizeConfiguration.isVerticalResizeAllowed()) {
                ret |= 5;
            }
        }
        return ret;
    }

    private IResizeShapeContext getResizeShapeContext() {
        return this.resizeShapeContext;
    }

    private IResizeShapeFeature getResizeShapeFeature() {
        if (this.getResizeShapeContext() == null) {
            return null;
        }
        return this.getConfigurationProvider().getFeatureProvider().getResizeShapeFeature(this.getResizeShapeContext());
    }

    private void setDelegate(GFEditPolicyDelegate delegate) {
        this.delegate = delegate;
    }

    private void setResizeShapeContext(IResizeShapeContext resizeShapeContext) {
        this.resizeShapeContext = resizeShapeContext;
    }

    protected void hideSelection() {
        this.getDelegate().hideSelection(this.getHostFigure());
        this.removeSelectionHandles();
    }

    protected void showPrimarySelection() {
        if (GraphitiInternal.getEmfService().isObjectAlive((EObject)((PictogramElement)this.getHost().getModel()))) {
            this.getDelegate().showPrimarySelection(this.getHostFigure());
            this.addSelectionHandles();
        }
    }

    protected void showSelection() {
        this.getDelegate().showSelection(this.getHostFigure());
        this.addSelectionHandles();
    }
}

