/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.parts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2dl.ConnectionAnchor;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.gef3.ConnectionEditPart;
import org.eclipse.gef3.DragTracker;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.NodeEditPart;
import org.eclipse.gef3.Request;
import org.eclipse.gef3.commands.Command;
import org.eclipse.gef3.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef3.requests.CreateConnectionRequest;
import org.eclipse.gef3.requests.CreationFactory;
import org.eclipse.gef3.tools.ConnectionDragCreationTool;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureAndContext;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.internal.features.context.impl.base.PictogramElementContext;
import org.eclipse.graphiti.mm.pictograms.AdvancedAnchor;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.internal.command.CreateConnectionCommand;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.parts.IAnchorEditPart;
import org.eclipse.graphiti.ui.internal.parts.IPictogramElementDelegate;
import org.eclipse.graphiti.ui.internal.parts.PictogramElementDelegate;
import org.eclipse.graphiti.ui.internal.util.draw2dl.GFChopboxAnchor;
import org.eclipse.graphiti.ui.internal.util.gef3.MultiCreationFactory;

public class AdvancedAnchorEditPart
extends AbstractGraphicalEditPart
implements IAnchorEditPart,
NodeEditPart {
    private ConnectionAnchor connectionAnchor;
    protected IPictogramElementDelegate delegate;

    public AdvancedAnchorEditPart(IConfigurationProviderInternal configurationProvider, AdvancedAnchor anchor) {
        this.setModel(anchor);
        this.delegate = new PictogramElementDelegate(configurationProvider, (PictogramElement)anchor, (EditPart)this);
    }

    public void activate() {
        super.activate();
        this.delegate.activate();
    }

    protected IFigure createFigure() {
        IFigure figure = this.delegate.createFigure();
        this.connectionAnchor = this.getModel() instanceof AdvancedAnchor ? new GFChopboxAnchor(figure, (AdvancedAnchor)this.getModel()) : new GFChopboxAnchor(figure);
        return figure;
    }

    public void deactivate() {
        this.delegate.deactivate();
        super.deactivate();
    }

    @Override
    public IConfigurationProviderInternal getConfigurationProvider() throws IllegalStateException {
        return this.delegate.getConfigurationProvider();
    }

    @Override
    public List<Connection> getModelSourceConnections() {
        Anchor anchor = (Anchor)this.getModel();
        ArrayList<Connection> connections = new ArrayList<Connection>();
        if (anchor != null) {
            connections.addAll((Collection<Connection>)anchor.getOutgoingConnections());
        }
        return connections;
    }

    @Override
    public List<Connection> getModelTargetConnections() {
        Anchor anchor = (Anchor)this.getModel();
        ArrayList<Connection> connections = new ArrayList<Connection>();
        if (anchor != null) {
            connections.addAll((Collection<Connection>)anchor.getIncomingConnections());
        }
        return connections;
    }

    @Override
    public PictogramElement getPictogramElement() {
        return this.delegate.getPictogramElement();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.connectionAnchor;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.connectionAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.connectionAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.connectionAnchor;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.delegate.refreshFigureForEditPart();
        this.getFigure().setVisible(this.getPictogramElement().isVisible());
    }

    protected void refreshChildren() {
        super.refreshChildren();
        this.delegate.refreshEditPartsForModelChildrenAndSourceConnections((EditPart)this);
    }

    @Override
    public List<PictogramElement> getModelChildren() {
        return new ArrayList<PictogramElement>();
    }

    public Object getAdapter(Class key) {
        Object ret = this.delegate.getAdapter(key);
        if (ret == null) {
            ret = super.getAdapter(key);
        }
        return ret;
    }

    public IFeatureProvider getFeatureProvider() {
        IFeatureProvider ret = null;
        if (this.delegate != null) {
            ret = this.delegate.getFeatureProvider();
        }
        return ret;
    }

    @Override
    public IPictogramElementDelegate getPictogramElementDelegate() {
        return this.delegate;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", this.getConfigurationProvider().getEditPolicyFactory().createModelObjectDeleteEditPolicy(this.getConfigurationProvider()));
        this.installEditPolicy("GraphicalNodeEditPolicy", this.getConfigurationProvider().getEditPolicyFactory().createConnectionEditPolicy());
    }

    public DragTracker getDragTracker(Request request) {
        PictogramElementContext context = new PictogramElementContext(this.getPictogramElement());
        IFeature[] dragAndDropFeatures = this.getConfigurationProvider().getDiagramTypeProvider().getFeatureProvider().getDragAndDropFeatures((IPictogramElementContext)context);
        if (dragAndDropFeatures == null || dragAndDropFeatures.length == 0) {
            return super.getDragTracker(request);
        }
        ConnectionDragCreationTool tool = new ConnectionDragCreationTool(){

            protected boolean handleCreateConnection() {
                Command endCommand = this.getCommand();
                this.setCurrentCommand(endCommand);
                if (endCommand == null || !endCommand.canExecute()) {
                    for (IFeatureAndContext ifac : this.getCreateConnectionFeaturesAndContext()) {
                        ICreateConnectionFeature ccf = (ICreateConnectionFeature)ifac.getFeature();
                        ccf.canceledAttaching((ICreateConnectionContext)ifac.getContext());
                    }
                }
                this.executeCurrentCommand();
                this.eraseSourceFeedback();
                return true;
            }

            protected void setState(int state) {
                if (this.isInState(1) && state == 64) {
                    for (IFeatureAndContext ifac : this.getCreateConnectionFeaturesAndContext()) {
                        ICreateConnectionFeature ccf = (ICreateConnectionFeature)ifac.getFeature();
                        ccf.startConnecting();
                        ccf.attachedToSource((ICreateConnectionContext)ifac.getContext());
                    }
                }
                super.setState(state);
            }

            public void handleFinished() {
                for (IFeatureAndContext ifac : this.getCreateConnectionFeaturesAndContext()) {
                    ICreateConnectionFeature ccf = (ICreateConnectionFeature)ifac.getFeature();
                    ccf.endConnecting();
                }
                super.handleFinished();
            }

            private Iterable<IFeatureAndContext> getCreateConnectionFeaturesAndContext() {
                if (this.getTargetRequest() instanceof CreateConnectionRequest) {
                    ArrayList<IFeatureAndContext> ret = new ArrayList<IFeatureAndContext>();
                    CreateConnectionRequest r = (CreateConnectionRequest)this.getTargetRequest();
                    if (r.getStartCommand() instanceof CreateConnectionCommand) {
                        CreateConnectionCommand cmd = (CreateConnectionCommand)r.getStartCommand();
                        IFeatureAndContext[] iFeatureAndContextArray = cmd.getFeaturesAndContexts();
                        int n = iFeatureAndContextArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IFeatureAndContext ifac = iFeatureAndContextArray[n2];
                            if (ifac.getFeature() instanceof ICreateConnectionFeature) {
                                ret.add(ifac);
                            }
                            ++n2;
                        }
                    }
                    return ret;
                }
                return Collections.emptyList();
            }
        };
        tool.setFactory((CreationFactory)new MultiCreationFactory(Arrays.asList(dragAndDropFeatures)));
        return tool;
    }

    public void eraseSourceFeedback(Request request) {
        super.eraseSourceFeedback(request);
        this.delegate.getVisualState().setHoverFeedback(1);
    }

    public void eraseTargetFeedback(Request request) {
        super.eraseTargetFeedback(request);
        this.delegate.getVisualState().setHoverFeedback(1);
    }

    public void showSourceFeedback(Request request) {
        super.showSourceFeedback(request);
        this.delegate.getVisualState().setHoverFeedback(0);
    }

    public void showTargetFeedback(Request request) {
        super.showTargetFeedback(request);
        this.delegate.getVisualState().setHoverFeedback(0);
    }

    @Override
    public void refreshDecorators() {
        this.delegate.refreshDecorators();
    }
}

