/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.figures;

import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.draw2dl.geometry.PointList;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.ui.internal.figures.GFAbstractShape;
import org.eclipse.graphiti.ui.internal.parts.IPictogramElementDelegate;

public abstract class GFAbstractPointListShape
extends GFAbstractShape {
    private PointList points = new PointList();

    public GFAbstractPointListShape(IPictogramElementDelegate pictogramElementDelegate, GraphicsAlgorithm graphicsAlgorithm) {
        super(pictogramElementDelegate, graphicsAlgorithm);
        this.bounds = null;
    }

    public final PointList getPoints() {
        return this.points;
    }

    public Point getStart() {
        return this.points.getFirstPoint();
    }

    public Point getEnd() {
        return this.points.getLastPoint();
    }

    public void addPoint(Point pt) {
        this.points.addPoint(pt);
        this.bounds = null;
        this.repaint();
    }

    public void insertPoint(Point pt, int index) {
        this.points.insertPoint(pt, index);
        this.bounds = null;
        this.repaint();
    }

    public void setPoint(Point pt, int index) {
        this.erase();
        this.points.setPoint(pt, index);
        this.bounds = null;
        this.repaint();
    }

    public void setPoints(PointList points) {
        this.erase();
        this.points = points;
        this.bounds = null;
        this.firePropertyChange("points", null, points);
        this.repaint();
    }

    public void setStart(Point start) {
        if (this.points.size() == 0) {
            this.addPoint(start);
        } else {
            this.setPoint(start, 0);
        }
    }

    public void setEnd(Point end) {
        if (this.points.size() < 2) {
            this.addPoint(end);
        } else {
            this.setPoint(end, this.points.size() - 1);
        }
    }

    public void removePoint(int index) {
        this.erase();
        this.bounds = null;
        this.points.removePoint(index);
    }

    public void removeAllPoints() {
        this.erase();
        this.bounds = null;
        this.points.removeAllPoints();
    }
}

