/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.action;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.commands.Command;
import org.eclipse.gef3.commands.CommandStack;
import org.eclipse.gef3.ui.actions.SelectionAction;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.internal.command.CommandContainer;
import org.eclipse.graphiti.internal.command.GenericFeatureCommandWithContext;
import org.eclipse.graphiti.internal.command.ICommand;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.internal.action.IAvailable;
import org.eclipse.graphiti.ui.internal.action.IContextAndFeatureProvider;
import org.eclipse.graphiti.ui.internal.command.GefCommandWrapper;
import org.eclipse.graphiti.ui.platform.IConfigurationProvider;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractPreDefinedAction
extends SelectionAction
implements IAvailable {
    private IConfigurationProvider configurationProvider;

    public AbstractPreDefinedAction(IWorkbenchPart part, IConfigurationProvider configurationProvider) {
        super(part);
        this.configurationProvider = configurationProvider;
    }

    protected IConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    protected IFeatureProvider getFeatureProvider() {
        return this.getConfigurationProvider().getDiagramTypeProvider().getFeatureProvider();
    }

    protected PictogramElement[] getSelectedPictogramElements() {
        List selectedObjects = this.getSelectedObjects();
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object o : selectedObjects) {
            EditPart editPart;
            if (!(o instanceof EditPart) || !((editPart = (EditPart)o).getModel() instanceof PictogramElement)) continue;
            list.add(editPart.getModel());
        }
        return list.toArray(new PictogramElement[0]);
    }

    protected void executeOnCommandStack(ICommand command) {
        CommandStack commandStack = this.getConfigurationProvider().getDiagramContainer().getEditDomain().getCommandStack();
        commandStack.execute((Command)new GefCommandWrapper(command, this.getConfigurationProvider().getDiagramBehavior().getEditingDomain()));
    }

    protected void genericRun(IContextAndFeatureProvider cfProvider) {
        IFeatureProvider featureProvider = this.getFeatureProvider();
        CommandContainer commandContainer = new CommandContainer(featureProvider);
        PictogramElement[] pes = this.getSelectedPictogramElements();
        int i = 0;
        while (i < pes.length) {
            PictogramElement pe = pes[i];
            IContext context = cfProvider.createContext(pe);
            IFeature feature = cfProvider.provideFeatureForContext(context);
            if (feature != null) {
                commandContainer.add((ICommand)new GenericFeatureCommandWithContext(feature, context));
            }
            ++i;
        }
        this.executeOnCommandStack((ICommand)commandContainer);
    }
}

