/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.math.BigInteger;
import oracle.security.crypto.core.EntropySource;
import oracle.security.crypto.core.SRRandomBitsSource;
import oracle.security.crypto.core.math.BigInt;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.fips.RNGTest;

public abstract class RandomBitsSource {
    private static RandomBitsSource a = null;
    private final RNGTest b = new RNGTest(this);
    private static final Object c = new Object();

    protected RandomBitsSource() {
    }

    protected final RNGTest a() {
        return this.b;
    }

    public abstract void seed(byte[] var1);

    public abstract void seed(EntropySource var1);

    public void seed() {
        this.seed(EntropySource.getDefault());
    }

    public abstract byte randomByte();

    public byte[] randomBytes(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = this.randomByte();
        }
        return byArray;
    }

    public BigInteger randomBigInteger(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid length " + n);
        }
        byte[] byArray = new byte[n % 8 == 0 ? n / 8 : n / 8 + 1];
        this.randomBytes(byArray);
        if (n % 8 != 0) {
            byArray[0] = (byte)(byArray[0] & (1 << n % 8) - 1);
        }
        return new BigInteger(1, byArray);
    }

    public BigInt randomBigInt(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid length " + n);
        }
        byte[] byArray = new byte[n % 8 == 0 ? n / 8 : n / 8 + 1];
        this.randomBytes(byArray);
        if (n % 8 != 0) {
            byArray[0] = (byte)(byArray[0] & (1 << n % 8) - 1);
        }
        return new BigInt(1, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RandomBitsSource getDefault() {
        FIPS_140_2.assertReadyState();
        if (a == null) {
            Object object = c;
            synchronized (object) {
                if (a == null) {
                    a = new SRRandomBitsSource();
                }
            }
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(RandomBitsSource randomBitsSource) {
        FIPS_140_2.assertReadyState();
        Object object = c;
        synchronized (object) {
            a = randomBitsSource;
        }
    }

    public abstract void clear();

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

