/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.jkiss.dbeaver.model.app.DBPPlatformEclipse;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPProjectListener;
import org.jkiss.dbeaver.model.navigator.DBNEmptyNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIExecutionQueue;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.INavigatorFilter;
import org.jkiss.dbeaver.ui.navigator.NavigatorStatePersister;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorContent;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilter;
import org.jkiss.dbeaver.ui.navigator.database.NavigatorViewBase;

public class DatabaseNavigatorView
extends NavigatorViewBase
implements DBPProjectListener {
    public static final String VIEW_ID = "org.jkiss.dbeaver.core.databaseNavigator";
    private IMemento memento;

    public DatabaseNavigatorView() {
        DBPPlatformEclipse.getInstance().getWorkspace().addProjectListener((DBPProjectListener)this);
    }

    public void saveState(IMemento memento) {
        DBPPreferenceStore preferences = DBWorkbench.getPlatform().getPreferenceStore();
        if (preferences.getInt("navigator.restore.state.depth") > 0) {
            NavigatorStatePersister.saveExpandedState(this.getNavigatorViewer().getExpandedElements(), memento);
        }
        if (preferences.getBoolean("navigator.restore.filters")) {
            NavigatorStatePersister.saveFilterState(this.getNavigatorTree(), memento);
        }
    }

    private void restoreState() {
        DBPPreferenceStore preferences = DBWorkbench.getPlatform().getPreferenceStore();
        int maxDepth = preferences.getInt("navigator.restore.state.depth");
        if (maxDepth > 0) {
            NavigatorStatePersister.restoreExpandedState(this.getNavigatorViewer(), this.getRootNode(), maxDepth, this.memento);
        }
        if (preferences.getBoolean("navigator.restore.filters")) {
            NavigatorStatePersister.restoreFilterState(this.getNavigatorTree(), this.memento);
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.memento = memento;
        super.init(site, memento);
    }

    @Override
    protected INavigatorFilter getNavigatorFilter() {
        return new DatabaseNavigatorTreeFilter();
    }

    @Override
    public DBNNode getRootNode() {
        DBNProject projectNode = this.getModel().getRoot().getProjectNode(DBWorkbench.getPlatform().getWorkspace().getActiveProject());
        return projectNode == null ? new DBNEmptyNode() : projectNode.getDatabases();
    }

    @Override
    public void dispose() {
        DBPPlatformEclipse.getInstance().getWorkspace().removeProjectListener((DBPProjectListener)this);
        super.dispose();
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        UIUtils.setHelp((Control)parent, (String)"view-database-navigator");
        UIExecutionQueue.queueExec(this::restoreState);
    }

    @Override
    protected void createTreeColumns(DatabaseNavigatorTree tree) {
    }

    public void handleProjectAdd(DBPProject project) {
    }

    public void handleProjectRemove(DBPProject project) {
    }

    public void handleActiveProjectChange(DBPProject oldValue, DBPProject newValue) {
        UIExecutionQueue.queueExec(() -> {
            this.getNavigatorTree().getViewer().setInput((Object)new DatabaseNavigatorContent(this.getRootNode()));
            this.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection());
        });
    }
}

