/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableConstraintColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableForeignKey;
import org.jkiss.dbeaver.ext.generic.model.GenericTableForeignKeyColumnTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndex;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.ext.generic.model.GenericUtils;
import org.jkiss.dbeaver.ext.generic.model.TableCache;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModelForeignKeyFetcher;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCCompositeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyDeferability;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.utils.CommonUtils;

class ForeignKeysCache
extends JDBCCompositeCache<GenericStructContainer, GenericTableBase, GenericTableForeignKey, GenericTableForeignKeyColumnTable> {
    private final Map<String, GenericUniqueKey> pkMap = new HashMap<String, GenericUniqueKey>();
    private final GenericMetaObject foreignKeyObject;
    private int fkIndex;

    ForeignKeysCache(TableCache tableCache) {
        super((JDBCStructCache)tableCache, GenericTableBase.class, GenericUtils.getColumn(tableCache.getDataSource(), "foreign-key", "FKTABLE_NAME"), GenericUtils.getColumn(tableCache.getDataSource(), "foreign-key", "FK_NAME"));
        this.foreignKeyObject = tableCache.getDataSource().getMetaObject("foreign-key");
        this.fkIndex = 1;
    }

    public void clearCache() {
        this.pkMap.clear();
        super.clearCache();
    }

    @NotNull
    protected JDBCStatement prepareObjectsStatement(JDBCSession session, GenericStructContainer owner, GenericTableBase forParent) throws SQLException {
        return owner.getDataSource().getMetaModel().prepareForeignKeysLoadStatement(session, owner, forParent);
    }

    @Nullable
    protected GenericTableForeignKey fetchObject(JDBCSession session, GenericStructContainer owner, GenericTableBase parent, String fkName, JDBCResultSet dbResult) throws SQLException, DBException {
        DBSForeignKeyDeferability deferability;
        DBSForeignKeyModifyRule updateRule;
        DBSForeignKeyModifyRule deleteRule;
        String pkTableCatalog = GenericUtils.safeGetStringTrimmed(this.foreignKeyObject, (ResultSet)dbResult, "PKTABLE_CAT");
        String pkTableSchema = GenericUtils.safeGetStringTrimmed(this.foreignKeyObject, (ResultSet)dbResult, "PKTABLE_SCHEM");
        String pkTableName = GenericUtils.safeGetStringTrimmed(this.foreignKeyObject, (ResultSet)dbResult, "PKTABLE_NAME");
        String fkTableCatalog = GenericUtils.safeGetStringTrimmed(this.foreignKeyObject, (ResultSet)dbResult, "FKTABLE_CAT");
        String fkTableSchema = GenericUtils.safeGetStringTrimmed(this.foreignKeyObject, (ResultSet)dbResult, "FKTABLE_SCHEM");
        int keySeq = GenericUtils.safeGetInt(this.foreignKeyObject, (ResultSet)dbResult, "KEY_SEQ");
        String pkName = GenericUtils.safeGetStringTrimmed(this.foreignKeyObject, (ResultSet)dbResult, "PK_NAME");
        GenericMetaModel metaModel = owner.getDataSource().getMetaModel();
        if (metaModel instanceof GenericMetaModelForeignKeyFetcher) {
            GenericMetaModelForeignKeyFetcher foreignKeyFetcher = (GenericMetaModelForeignKeyFetcher)((Object)metaModel);
            deleteRule = foreignKeyFetcher.fetchDeleteRule(this.foreignKeyObject, dbResult);
            updateRule = foreignKeyFetcher.fetchUpdateRule(this.foreignKeyObject, dbResult);
            deferability = foreignKeyFetcher.fetchDeferability(this.foreignKeyObject, dbResult);
        } else {
            int updateRuleNum = GenericUtils.safeGetInt(this.foreignKeyObject, (ResultSet)dbResult, "UPDATE_RULE");
            int deleteRuleNum = GenericUtils.safeGetInt(this.foreignKeyObject, (ResultSet)dbResult, "DELETE_RULE");
            int deferabilityNum = GenericUtils.safeGetInt(this.foreignKeyObject, (ResultSet)dbResult, "DEFERRABILITY");
            deleteRule = JDBCUtils.getCascadeFromNum((int)deleteRuleNum);
            updateRule = JDBCUtils.getCascadeFromNum((int)updateRuleNum);
            switch (deferabilityNum) {
                case 5: {
                    deferability = DBSForeignKeyDeferability.INITIALLY_DEFERRED;
                    break;
                }
                case 6: {
                    deferability = DBSForeignKeyDeferability.INITIALLY_IMMEDIATE;
                    break;
                }
                case 7: {
                    deferability = DBSForeignKeyDeferability.NOT_DEFERRABLE;
                    break;
                }
                default: {
                    deferability = DBSForeignKeyDeferability.UNKNOWN;
                }
            }
        }
        if (pkTableName == null) {
            log.debug((Object)"Null PK table name");
            return null;
        }
        String pkTableFullName = DBUtils.getSimpleQualifiedName((Object[])new Object[]{pkTableCatalog, pkTableSchema, pkTableName});
        GenericTableBase pkTable = ((GenericDataSource)parent.getDataSource()).findTable(session.getProgressMonitor(), pkTableCatalog, pkTableSchema, pkTableName);
        if (pkTable == null) {
            pkTable = ((GenericDataSource)parent.getDataSource()).findTable(session.getProgressMonitor(), fkTableCatalog, fkTableSchema, pkTableName);
            if (pkTable == null) {
                log.warn((Object)("Can't find PK table " + pkTableName));
                return null;
            }
            log.debug((Object)("PK table " + pkTableFullName + " was taken from FK container."));
        }
        Object pk = null;
        if (!CommonUtils.isEmpty((String)pkName) && (pk = (DBSEntityReferrer)DBUtils.findObject((Collection)pkTable.getConstraints(session.getProgressMonitor()), (String)pkName)) == null) {
            log.debug((Object)("Unique key '" + pkName + "' not found in table " + pkTable.getFullyQualifiedName(DBPEvaluationContext.DDL) + " for foreign key " + fkName + " in table " + parent.getName()));
        }
        if (pk == null) {
            Collection<? extends GenericTableIndex> indexes;
            String pkColumnName = GenericUtils.safeGetStringTrimmed(this.foreignKeyObject, (ResultSet)dbResult, "PKCOLUMN_NAME");
            GenericTableColumn pkColumn = pkTable.getAttribute(session.getProgressMonitor(), pkColumnName);
            if (pkColumn == null) {
                log.warn((Object)("Can't find PK table " + pkTable.getFullyQualifiedName(DBPEvaluationContext.DDL) + " column " + pkColumnName));
                return null;
            }
            Collection uniqueKeys = pkTable.getConstraints(session.getProgressMonitor());
            if (uniqueKeys != null) {
                for (GenericUniqueKey pkConstraint : uniqueKeys) {
                    if (!pkConstraint.getConstraintType().isUnique() || DBUtils.getConstraintAttribute((DBRProgressMonitor)session.getProgressMonitor(), (DBSEntityReferrer)pkConstraint, (DBSEntityAttribute)pkColumn) == null) continue;
                    pk = pkConstraint;
                    break;
                }
            }
            if (pk == null && (indexes = pkTable.getIndexes(session.getProgressMonitor())) != null) {
                for (GenericTableIndex genericTableIndex : indexes) {
                    if (!genericTableIndex.isUnique() || DBUtils.getConstraintAttribute((DBRProgressMonitor)session.getProgressMonitor(), (DBSEntityReferrer)genericTableIndex, (DBSEntityAttribute)pkColumn) == null) continue;
                    pk = genericTableIndex;
                    break;
                }
            }
            if (pk == null) {
                String string;
                GenericUniqueKey fakePk;
                log.warn((Object)("Can't find unique key for table " + pkTable.getFullyQualifiedName(DBPEvaluationContext.DDL) + " column " + pkColumn.getName() + ". Making fake one."));
                if (pkName == null) {
                    pkName = "primary_key";
                }
                if ((fakePk = this.pkMap.get(string = String.valueOf(pkTable.getFullyQualifiedName(DBPEvaluationContext.DDL)) + "." + pkName)) == null) {
                    fakePk = ((GenericDataSource)pkTable.getDataSource()).getMetaModel().createConstraintImpl(pkTable, pkName, DBSEntityConstraintType.PRIMARY_KEY, dbResult, true);
                    this.pkMap.put(string, fakePk);
                    ((GenericTableBase)fakePk.getTable()).addUniqueKey(fakePk);
                }
                fakePk.addColumn(new GenericTableConstraintColumn(fakePk, pkColumn, keySeq));
                pk = fakePk;
            }
        }
        if (CommonUtils.isEmpty((String)fkName)) {
            fkName = String.valueOf(parent.getName().toUpperCase()) + "_FK_" + pkTable.getName().toUpperCase(Locale.ENGLISH);
        }
        return owner.getDataSource().getMetaModel().createTableForeignKeyImpl(parent, fkName, null, (DBSEntityReferrer)pk, deleteRule, updateRule, deferability, true);
    }

    @Nullable
    protected GenericTableForeignKeyColumnTable[] fetchObjectRow(JDBCSession session, GenericTableBase parent, GenericTableForeignKey foreignKey, JDBCResultSet dbResult) throws SQLException, DBException {
        String pkColumnName = GenericUtils.safeGetStringTrimmed(this.foreignKeyObject, (ResultSet)dbResult, "PKCOLUMN_NAME");
        DBSEntityReferrer referencedConstraint = (DBSEntityReferrer)foreignKey.getReferencedConstraint();
        if (referencedConstraint == null) {
            log.warn((Object)("Null reference constraint in FK '" + foreignKey.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'"));
            return null;
        }
        DBSEntityAttributeRef pkColumn = DBUtils.getConstraintAttribute((DBRProgressMonitor)session.getProgressMonitor(), (DBSEntityReferrer)referencedConstraint, (String)pkColumnName);
        if (pkColumn == null) {
            log.warn((Object)("Can't find PK table " + DBUtils.getObjectFullName((DBPNamedObject)referencedConstraint.getParentObject(), (DBPEvaluationContext)DBPEvaluationContext.DML) + " column " + pkColumnName));
            return null;
        }
        int keySeq = GenericUtils.safeGetInt(this.foreignKeyObject, (ResultSet)dbResult, "KEY_SEQ");
        String fkColumnName = GenericUtils.safeGetStringTrimmed(this.foreignKeyObject, (ResultSet)dbResult, "FKCOLUMN_NAME");
        if (CommonUtils.isEmpty((String)fkColumnName)) {
            log.warn((Object)("Empty FK column for table " + ((GenericTableBase)foreignKey.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " PK column " + pkColumnName));
            return null;
        }
        GenericTableColumn fkColumn = ((GenericTableBase)foreignKey.getTable()).getAttribute(session.getProgressMonitor(), fkColumnName);
        if (fkColumn == null) {
            log.warn((Object)("Can't find FK table " + ((GenericTableBase)foreignKey.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " column " + fkColumnName));
            return null;
        }
        return new GenericTableForeignKeyColumnTable[]{new GenericTableForeignKeyColumnTable(foreignKey, fkColumn, keySeq, (GenericTableColumn)pkColumn.getAttribute())};
    }

    protected void cacheChildren(DBRProgressMonitor monitor, GenericTableForeignKey foreignKey, List<GenericTableForeignKeyColumnTable> rows) {
        foreignKey.setColumns(monitor, rows);
        this.fkIndex = 1;
    }

    protected String getDefaultObjectName(JDBCResultSet dbResult, String parentName) {
        String pkTableName = GenericUtils.safeGetStringTrimmed(this.foreignKeyObject, (ResultSet)dbResult, "PKTABLE_NAME");
        int keySeq = GenericUtils.safeGetInt(this.foreignKeyObject, (ResultSet)dbResult, "KEY_SEQ");
        String fkName = "FK_" + parentName + "_" + pkTableName;
        if (this.fkIndex > 1 && keySeq == 1) {
            fkName = String.valueOf(fkName) + "_" + this.fkIndex;
        }
        ++this.fkIndex;
        return fkName;
    }
}

