/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.createSynonym;

import java.text.MessageFormat;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.createSynonym.CreateSynonymStatement;
import liquibase.ext.ora.dropSynonym.DropSynonymChange;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createSynonym", description="Create synonym", priority=201)
public class CreateSynonymChange
extends AbstractChange {
    private Boolean replace;
    private Boolean isPublic;
    private String objectName;
    private String objectSchemaName;
    private String synonymName;
    private String synonymSchemaName;

    public Boolean isReplace() {
        return this.replace;
    }

    public void setReplace(Boolean replace) {
        this.replace = replace;
    }

    public Boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(Boolean isPublic) {
        this.isPublic = isPublic;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getObjectSchemaName() {
        return this.objectSchemaName;
    }

    public void setObjectSchemaName(String objectSchemaName) {
        this.objectSchemaName = objectSchemaName;
    }

    public String getSynonymName() {
        return this.synonymName;
    }

    public void setSynonymName(String synonymName) {
        this.synonymName = synonymName;
    }

    public String getSynonymSchemaName() {
        return this.synonymSchemaName;
    }

    public void setSynonymSchemaName(String synonymSchemaName) {
        this.synonymSchemaName = synonymSchemaName;
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Synonym {0} created", this.getSynonymName());
    }

    protected Change[] createInverses() {
        DropSynonymChange inverse = new DropSynonymChange();
        inverse.setPublic(this.isPublic());
        inverse.setSynonymName(this.getSynonymName());
        inverse.setSynonymSchemaName(this.getSynonymSchemaName());
        return new Change[]{inverse};
    }

    public SqlStatement[] generateStatements(Database database) {
        CreateSynonymStatement statement = new CreateSynonymStatement();
        statement.setObjectName(this.getObjectName());
        statement.setObjectSchemaName(this.getObjectSchemaName());
        statement.setSynonymName(this.getSynonymName());
        statement.setSynonymSchemaName(this.getSynonymSchemaName());
        statement.setReplace(this.isReplace());
        statement.setPublic(this.isPublic());
        return new SqlStatement[]{statement};
    }
}

