/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.model;

import com.datastax.driver.core.IndexMetadata;
import com.dbeaver.db.cassandra.model.CasTable;
import com.dbeaver.db.cassandra.model.CasTableColumn;
import com.dbeaver.db.cassandra.model.CasTableIndexColumn;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.utils.CommonUtils;

public class CasTableIndex
implements DBSTableIndex {
    private static final Log log = Log.getLog(CasTableIndex.class);
    private final CasTable table;
    private String name;
    private String query;
    private String columnName;
    private String indexClassName;
    private boolean isCustom;
    private boolean persisted;
    private List<CasTableIndexColumn> indexColumns = new ArrayList<CasTableIndexColumn>();

    public CasTableIndex(CasTable table, IndexMetadata metadata) {
        this.table = table;
        this.name = metadata.getName();
        this.query = metadata.asCQLQuery();
        this.columnName = metadata.getTarget();
        this.isCustom = metadata.isCustomIndex();
        this.indexClassName = metadata.getIndexClassName();
        this.persisted = true;
    }

    public CasTableIndex(CasTable table, String name, boolean persisted) {
        this.table = table;
        this.name = name;
        this.persisted = persisted;
    }

    public DBSTable getContainer() {
        return this.table;
    }

    public CasTable getTable() {
        return this.table;
    }

    @Nullable
    public String getIndexClassName() {
        return this.indexClassName;
    }

    public void setIndexClassName(String indexClassName) {
        this.indexClassName = indexClassName;
    }

    @Property(viewable=true, order=2)
    public boolean isCustom() {
        return this.isCustom;
    }

    public void setCustom(boolean custom) {
        this.isCustom = custom;
    }

    public boolean isUnique() {
        return false;
    }

    public boolean isPrimary() {
        return false;
    }

    public DBSIndexType getIndexType() {
        return DBSIndexType.CLUSTERED;
    }

    public List<CasTableIndexColumn> getAttributeReferences(DBRProgressMonitor monitor) {
        if (CommonUtils.isEmpty(this.indexColumns) && CommonUtils.isNotEmpty((String)this.columnName)) {
            try {
                if (this.columnName.contains(",")) {
                    String[] columnNames;
                    String[] stringArray = columnNames = this.columnName.split(",");
                    int n = columnNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name = stringArray[n2];
                        if (CommonUtils.isNotEmpty((String)name)) {
                            CasTableColumn attribute = this.table.getAttribute(monitor, name.trim());
                            this.indexColumns.add(new CasTableIndexColumn(this, attribute));
                        }
                        ++n2;
                    }
                } else {
                    CasTableColumn attribute = this.table.getAttribute(monitor, this.columnName);
                    this.indexColumns.add(new CasTableIndexColumn(this, attribute));
                }
            }
            catch (DBException e) {
                log.warn((Object)("Can't find index '" + this.getName() + "' column"), (Throwable)e);
            }
        }
        return this.indexColumns;
    }

    public void addIndexColumn(CasTableIndexColumn column) {
        this.indexColumns.add(column);
    }

    public String getDescription() {
        return null;
    }

    @NotNull
    public DBSEntity getParentObject() {
        return this.table;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.table.getDataSource();
    }

    @NotNull
    public DBSEntityConstraintType getConstraintType() {
        return DBSEntityConstraintType.INDEX;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getQuotedIdentifier((DBSObject)this);
    }

    @Property(viewable=true)
    public String getQuery() {
        return this.query;
    }
}

