/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.data.handlers;

import com.dbeaver.db.cassandra.data.handlers.CasBaseValueHandler;
import com.dbeaver.db.cassandra.exec.CasPreparedStatement;
import com.dbeaver.db.cassandra.exec.CasSession;
import com.dbeaver.ee.model.content.DBContentByteBuffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CasContentValueHandler
extends CasBaseValueHandler {
    public static final CasContentValueHandler INSTANCE = new CasContentValueHandler();

    @NotNull
    public Class<DBDContent> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return DBDContent.class;
    }

    @Override
    public Object fetchValueObject(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, @NotNull DBSTypedObject type, int index) throws DBCException {
        Object value = super.fetchValueObject(session, resultSet, type, index);
        return this.getValueFromObject(session, type, value, false, false);
    }

    public DBContentByteBuffer getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        CasSession casSession = (CasSession)session;
        if (object == null) {
            return new DBContentByteBuffer((DBCExecutionContext)casSession.getExecutionContext());
        }
        if (object instanceof DBContentByteBuffer) {
            DBContentByteBuffer src = (DBContentByteBuffer)object;
            return copy ? new DBContentByteBuffer((DBCExecutionContext)casSession.getExecutionContext(), src.getData()) : src;
        }
        if (object instanceof ByteBuffer) {
            return new DBContentByteBuffer((DBCExecutionContext)casSession.getExecutionContext(), (ByteBuffer)object);
        }
        if (object instanceof byte[]) {
            return new DBContentByteBuffer((DBCExecutionContext)casSession.getExecutionContext(), ByteBuffer.wrap((byte[])object));
        }
        if (object instanceof String) {
            return new DBContentByteBuffer((DBCExecutionContext)casSession.getExecutionContext(), ByteBuffer.wrap(((String)object).getBytes(StandardCharsets.UTF_8)));
        }
        throw new DBCException("Unsupported struct type: " + object.getClass().getName());
    }

    @Override
    protected void bindParameter(CasSession session, CasPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException {
        statement.getBoundStatement().setBytes(paramIndex, ((DBContentByteBuffer)value).getData());
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof DBDContent) {
            String result = ((DBDContent)value).getDisplayString(format);
            if (result == null) {
                return super.getValueDisplayString(column, null, format);
            }
            return result;
        }
        return super.getValueDisplayString(column, value, format);
    }
}

