/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.db2i.sqlgenerator;

import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.ValidationErrors;
import liquibase.ext.db2i.database.DB2iDatabase;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.SetNullableGenerator;
import liquibase.statement.core.SetNullableStatement;

public class SetNullableGeneratorDB2i
extends SetNullableGenerator {
    public boolean supports(SetNullableStatement statement, Database database) {
        return database instanceof DB2iDatabase;
    }

    public int getPriority() {
        return 5;
    }

    public ValidationErrors validate(SetNullableStatement setNullableStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("tableName", (Object)setNullableStatement.getTableName());
        validationErrors.checkRequiredField("columnName", (Object)setNullableStatement.getColumnName());
        try {
            if (database instanceof DB2iDatabase && database.getDatabaseMajorVersion() > 0 && database.getDatabaseMajorVersion() < 4) {
                validationErrors.addError("DB2i versions less than 4 do not support modifying null constraints");
            }
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        return validationErrors;
    }
}

