/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.vertica.sqlgenerator;

import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.ext.vertica.change.ColumnConfigVertica;
import liquibase.ext.vertica.database.VerticaDatabase;
import liquibase.ext.vertica.statement.CreateProjectionStatement;
import liquibase.ext.vertica.structure.GroupedColumns;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class CreateProjectionGeneratorVertica
extends AbstractSqlGenerator<CreateProjectionStatement> {
    public ValidationErrors validate(CreateProjectionStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("projectionName", (Object)statement.getProjectionName());
        return validationErrors;
    }

    public Sql[] generateSql(CreateProjectionStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder sql = new StringBuilder();
        sql.append("create PROJECTION ");
        if (statement.getSchemaName() != null) {
            sql.append(statement.getSchemaName()).append(".");
        } else {
            sql.append(database.getDefaultSchemaName()).append(".");
        }
        if (statement.getProjectionName() != null) {
            sql.append(statement.getProjectionName()).append(" ");
        }
        if (!statement.getColumns().isEmpty() || !statement.getGroupedColumns().isEmpty()) {
            sql.append("(");
            String delim = "";
            for (ColumnConfigVertica column : statement.getColumns()) {
                sql.append(delim).append(" ").append(column.getName());
                if (column.getEncoding() != null) {
                    sql.append(" ENCODING ").append(column.getEncoding());
                }
                if (column.getAccessrank() != null) {
                    sql.append(" ").append(column.getAccessrank());
                }
                delim = ",";
            }
            if (!statement.getGroupedColumns().isEmpty()) {
                for (GroupedColumns group : statement.getGroupedColumns()) {
                    sql.append(delim).append(" GROUPED (");
                    delim = "";
                    for (ColumnConfigVertica column : group.getColumns()) {
                        sql.append(delim).append(" ").append(column.getName());
                        if (column.getEncoding() != null) {
                            sql.append(" ENCODING ").append(column.getEncoding());
                        }
                        if (column.getAccessrank() != null) {
                            sql.append(" ").append(column.getAccessrank());
                        }
                        delim = ",";
                    }
                    sql.append(")");
                }
            }
            sql.append(")");
        }
        sql.append(" AS ");
        if (statement.getSubquery() != null) {
            sql.append(statement.getSubquery());
        }
        if (statement.getOrderby() != null) {
            sql.append(" ORDER BY ").append(statement.getOrderby());
        }
        if (statement.getSegmentedby() == null) {
            sql.append(" UNSEGMENTED ");
        } else {
            sql.append(" SEGMENTED BY ");
            sql.append(statement.getSegmentedby());
        }
        if (statement.getNodes().contains("ALL")) {
            sql.append(" ALL NODES ");
            if (statement.getOffset() != null) {
                sql.append(" OFFSET ").append(statement.getOffset().toString());
            }
        } else {
            sql.append(" ").append(statement.getNodes());
        }
        if (statement.getKsafe() != null) {
            sql.append(" KSAFE ");
            if (!statement.getKsafe().isEmpty()) {
                sql.append(statement.getKsafe());
            }
        }
        System.out.println(sql.toString());
        return new Sql[]{new UnparsedSql(sql.toString(), new DatabaseObject[0])};
    }

    public boolean supports(CreateProjectionStatement statement, Database database) {
        return database instanceof VerticaDatabase;
    }
}

