/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.vertica.precondition;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.ParsedNodeException;
import liquibase.precondition.Precondition;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.structure.core.Column;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.JdbcUtils;
import liquibase.util.StringUtil;

public class ColumnExistsPrecondition
implements Precondition {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String columnName;
    private static Map<String, Map<String, Boolean>> columnExists;

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public Warnings warn(Database database) {
        return new Warnings();
    }

    public ValidationErrors validate(Database database) {
        return new ValidationErrors();
    }

    public void check(Database database, DatabaseChangeLog changeLog, ChangeSet changeSet, ChangeExecListener changeExecListener) throws PreconditionFailedException, PreconditionErrorException {
        Column example = new Column();
        if (StringUtil.trimToNull((String)this.getTableName()) != null) {
            example.setRelation(new Table().setName(this.getTableName()).setSchema(new Schema(this.getCatalogName(), this.getSchemaName())));
        }
        example.setName(this.getColumnName());
        DatabaseConnection dbConn = database.getConnection();
        if (columnExists == null) {
            columnExists = new HashMap<String, Map<String, Boolean>>();
            HashMap tableColumnsExists = new HashMap();
            this.createExistingColumnsMap((JdbcConnection)dbConn, tableColumnsExists);
        } else if (columnExists.get(this.getTableName()) == null) {
            HashMap tableColumnsExists = new HashMap();
            this.createExistingColumnsMap((JdbcConnection)dbConn, tableColumnsExists);
        } else if (columnExists.get(this.getTableName()).get(this.getColumnName()) == null) {
            Scope.getCurrentScope().getLog(this.getClass()).fine("Column found in cache :" + this.getColumnName());
            throw new PreconditionFailedException("Column '" + database.escapeColumnName(this.catalogName, this.schemaName, this.getTableName(), this.getColumnName()) + "' does not exist", changeLog, (Precondition)this);
        }
    }

    public String getSerializedObjectName() {
        return null;
    }

    public Set<String> getSerializableFields() {
        return null;
    }

    public Object getSerializableFieldValue(String field) {
        return null;
    }

    public LiquibaseSerializable.SerializationType getSerializableFieldType(String field) {
        return null;
    }

    public String getSerializableFieldNamespace(String field) {
        return null;
    }

    public String getSerializedObjectNamespace() {
        return null;
    }

    public void load(ParsedNode parsedNode, ResourceAccessor resourceAccessor) throws ParsedNodeException {
    }

    public ParsedNode serialize() throws ParsedNodeException {
        return null;
    }

    private void createExistingColumnsMap(JdbcConnection dbConn, Map tableColumnsExists) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.createStatement();
            rs = stmt.executeQuery("select column_name from columns where table_schema ='" + this.schemaName + "' and table_name='" + this.getTableName() + "' ");
            while (rs.next()) {
                tableColumnsExists.put(rs.getString("column_name"), Boolean.TRUE);
            }
            columnExists.put(this.getTableName(), tableColumnsExists);
        }
        catch (Exception e) {
            try {
                Scope.getCurrentScope().getLog(this.getClass()).info("Error fetching columns name from metadata ", (Throwable)e);
                throw new RuntimeException("Error fetching columns name from metadata ", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement((Statement)stmt);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet((ResultSet)rs);
        JdbcUtils.closeStatement((Statement)stmt);
    }

    public String getName() {
        return "columnExists";
    }
}

