/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.vertica.diff.compare;

import java.util.Set;
import liquibase.database.Database;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.compare.DatabaseObjectComparator;
import liquibase.diff.compare.DatabaseObjectComparatorChain;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.diff.compare.core.DefaultDatabaseObjectComparator;
import liquibase.ext.vertica.database.VerticaDatabase;
import liquibase.ext.vertica.structure.Projection;
import liquibase.structure.DatabaseObject;

public class ProjectionComparator
implements DatabaseObjectComparator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (database instanceof VerticaDatabase && Projection.class.isAssignableFrom(objectType)) {
            return 5;
        }
        return -1;
    }

    public String[] hash(DatabaseObject databaseObject, Database accordingTo, DatabaseObjectComparatorChain chain) {
        return chain.hash(databaseObject, accordingTo);
    }

    public boolean isSameObject(DatabaseObject databaseObject1, DatabaseObject databaseObject2, Database accordingTo, DatabaseObjectComparatorChain chain) {
        if (!(databaseObject1 instanceof Projection) || !(databaseObject2 instanceof Projection)) {
            return false;
        }
        if (!DefaultDatabaseObjectComparator.nameMatches((DatabaseObject)databaseObject1, (DatabaseObject)databaseObject2, (Database)accordingTo)) {
            return false;
        }
        return DatabaseObjectComparatorFactory.getInstance().isSameObject((DatabaseObject)databaseObject1.getSchema(), (DatabaseObject)databaseObject2.getSchema(), chain.getSchemaComparisons(), accordingTo);
    }

    public ObjectDifferences findDifferences(DatabaseObject databaseObject1, DatabaseObject databaseObject2, Database accordingTo, CompareControl compareControl, DatabaseObjectComparatorChain chain, Set<String> exclude) {
        exclude.add("indexes");
        exclude.add("name");
        exclude.add("outgoingForeignKeys");
        exclude.add("uniqueConstraints");
        exclude.add("primaryKey");
        exclude.add("columns");
        ObjectDifferences differences = chain.findDifferences(databaseObject1, databaseObject2, accordingTo, compareControl, exclude);
        differences.compare("name", databaseObject1, databaseObject2, (ObjectDifferences.CompareFunction)new ObjectDifferences.DatabaseObjectNameCompareFunction(Projection.class, accordingTo));
        return differences;
    }
}

