/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.vertica.change;

import java.util.ArrayList;
import java.util.List;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.vertica.change.ColumnConfigVertica;
import liquibase.ext.vertica.change.DropProjectionChange;
import liquibase.ext.vertica.database.VerticaDatabase;
import liquibase.ext.vertica.statement.CreateProjectionStatement;
import liquibase.ext.vertica.structure.GroupedColumns;
import liquibase.ext.vertica.structure.Segmentation;
import liquibase.statement.SqlStatement;
import liquibase.util.StringUtil;

@DatabaseChange(name="createProjection", description="create projections", priority=5)
public class CreateProjectionChange
extends AbstractChange
implements ChangeWithColumns<ColumnConfigVertica> {
    private String tableName;
    private String projectionName;
    private String schemaName;
    private String viewName;
    private String columnAliases;
    private String objectType;
    private Boolean reducedPrecision;
    private Boolean usingIndex;
    private String tableSpace;
    private Boolean forUpdate;
    private String orderby;
    private String ksafe;
    private List<GroupedColumns> groupedColumns;
    private Segmentation segmentation;
    private String segmentedby;
    private Integer offset;
    private String nodes;
    private String subquery;
    private List<ColumnConfigVertica> columns = new ArrayList<ColumnConfigVertica>();
    private String remarks;

    public String getColumnAliases() {
        return this.columnAliases;
    }

    public void setColumnAliases(String columnAliases) {
        this.columnAliases = columnAliases;
    }

    public CreateProjectionChange() {
        this.groupedColumns = new ArrayList<GroupedColumns>();
    }

    public String getProjectionName() {
        return this.projectionName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getOrderby() {
        return this.orderby;
    }

    public void setOrderby(String orderby) {
        this.orderby = orderby;
    }

    public void setProjectionName(String projectionName) {
        this.projectionName = projectionName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtil.trimToNull((String)schemaName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void addColumn(ColumnConfigVertica column) {
        this.columns.add(column);
    }

    public List<ColumnConfigVertica> getColumns() {
        return this.columns;
    }

    public void setColumns(List columns) {
        this.columns = columns;
    }

    public String getKsafe() {
        return this.ksafe;
    }

    public void setKsafe(String ksafe) {
        this.ksafe = ksafe;
    }

    public void removeColumn(ColumnConfig column) {
        this.columns.remove(column);
    }

    public String getSubquery() {
        return this.subquery;
    }

    public void setSubquery(String subquery) {
        this.subquery = subquery;
    }

    public SqlStatement[] generateStatements(Database database) {
        CreateProjectionStatement statement = new CreateProjectionStatement(this.getSchemaName(), this.getProjectionName(), this.getTableName(), this.getColumns());
        statement.setGroupedColumns(this.getGroupedColumns());
        statement.setSchemaName(this.getSchemaName());
        statement.setOffset(this.getOffset());
        statement.setNodes(this.getNodes());
        statement.setSegmentedby(this.getSegmentedby());
        statement.setSubquery(this.getSubquery());
        statement.setOrderby(this.getOrderby());
        statement.setKsafe(this.getKsafe());
        return new SqlStatement[]{statement};
    }

    public String getConfirmationMessage() {
        return "Projection " + this.getProjectionName() + " has been created";
    }

    protected Change[] createInverses() {
        DropProjectionChange inverse = new DropProjectionChange();
        inverse.setSchemaName(this.getSchemaName());
        inverse.setTableName(this.getTableName());
        inverse.setProjectionName(this.getProjectionName());
        inverse.setCascade(Boolean.FALSE);
        return new Change[]{inverse};
    }

    public boolean supports(Database database) {
        return database instanceof VerticaDatabase;
    }

    public ColumnConfigVertica createColumnv() {
        ColumnConfigVertica col = new ColumnConfigVertica();
        this.columns.add(col);
        return col;
    }

    public GroupedColumns createGrouped() {
        GroupedColumns group = new GroupedColumns();
        this.groupedColumns.add(group);
        return group;
    }

    public Segmentation createSegmentation() {
        this.segmentation = new Segmentation();
        return this.segmentation;
    }

    public List<GroupedColumns> getGroupedColumns() {
        return this.groupedColumns;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getSegmentedby() {
        return this.segmentedby;
    }

    public void setSegmentedby(String segmentedby) {
        this.segmentedby = segmentedby;
    }

    public String getNodes() {
        return this.nodes;
    }

    public void setNodes(String nodes) {
        this.nodes = nodes;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog-ext";
    }
}

