/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.apache.http.HttpEntity;
import org.apache.http.entity.InputStreamEntity;
import ru.yandex.clickhouse.ClickHouseStatementImpl;
import ru.yandex.clickhouse.ConfigurableApi;
import ru.yandex.clickhouse.domain.ClickHouseCompression;
import ru.yandex.clickhouse.domain.ClickHouseFormat;
import ru.yandex.clickhouse.util.ClickHouseStreamCallback;
import ru.yandex.clickhouse.util.ClickHouseStreamHttpEntity;

public class Writer
extends ConfigurableApi<Writer> {
    private ClickHouseFormat format = ClickHouseFormat.TabSeparated;
    private ClickHouseCompression compression = null;
    private String table = null;
    private String sql = null;
    private InputStreamProvider streamProvider = null;

    Writer(ClickHouseStatementImpl statement) {
        super(statement);
    }

    public Writer format(ClickHouseFormat format) {
        if (null == format) {
            throw new NullPointerException("Format can not be null");
        }
        this.format = format;
        return this;
    }

    public Writer table(String table) {
        this.sql = null;
        this.table = table;
        return this;
    }

    public Writer sql(String sql) {
        this.sql = sql;
        this.table = null;
        return this;
    }

    public Writer data(InputStream stream) {
        this.streamProvider = new HoldingInputProvider(stream);
        return this;
    }

    public Writer data(InputStream stream, ClickHouseFormat format) {
        return this.format(format).data(stream);
    }

    public Writer data(File input) {
        this.streamProvider = new FileInputProvider(input);
        return this;
    }

    public Writer data(InputStream stream, ClickHouseFormat format, ClickHouseCompression compression) {
        return this.dataCompression(compression).format(format).data(stream);
    }

    public Writer data(File input, ClickHouseFormat format, ClickHouseCompression compression) {
        return this.dataCompression(compression).format(format).data(input);
    }

    public Writer dataCompression(ClickHouseCompression compression) {
        if (null == compression) {
            throw new NullPointerException("Compression can not be null");
        }
        this.compression = compression;
        return this;
    }

    public Writer data(File input, ClickHouseFormat format) {
        return this.format(format).data(input);
    }

    public void send() throws SQLException {
        InputStreamEntity entity;
        try {
            InputStream stream;
            if (null == this.streamProvider || null == (stream = this.streamProvider.get())) {
                throw new IOException("No input data specified");
            }
            entity = new InputStreamEntity(stream);
        }
        catch (IOException err) {
            throw new SQLException(err);
        }
        this.send((HttpEntity)entity);
    }

    private void send(HttpEntity entity) throws SQLException {
        this.statement.sendStream(this, entity);
    }

    public void send(String sql, InputStream data, ClickHouseFormat format) throws SQLException {
        this.sql(sql).data(data).format(format).send();
    }

    public void sendToTable(String table, InputStream data, ClickHouseFormat format) throws SQLException {
        this.table(table).data(data).format(format).send();
    }

    public void send(String sql, ClickHouseStreamCallback callback, ClickHouseFormat format) throws SQLException {
        if (!ClickHouseFormat.RowBinary.equals((Object)format) && !ClickHouseFormat.Native.equals((Object)format)) {
            throw new SQLException("Wrong binary format - only RowBinary and Native are supported");
        }
        this.format(format).sql(sql).send((HttpEntity)new ClickHouseStreamHttpEntity(callback, this.statement.getConnection().getTimeZone(), this.statement.properties));
    }

    String getSql() {
        if (null != this.table) {
            return "INSERT INTO " + this.table + " FORMAT " + (Object)((Object)this.format);
        }
        if (null != this.sql) {
            String result = this.sql;
            if (!ClickHouseFormat.containsFormat(result)) {
                result = result + " FORMAT " + (Object)((Object)this.format);
            }
            return result;
        }
        throw new IllegalArgumentException("Neither table nor SQL clause are specified");
    }

    public ClickHouseCompression getCompression() {
        return this.compression;
    }

    private static final class HoldingInputProvider
    implements InputStreamProvider {
        private final InputStream stream;

        private HoldingInputProvider(InputStream stream) {
            this.stream = stream;
        }

        @Override
        public InputStream get() throws IOException {
            return this.stream;
        }
    }

    private static final class FileInputProvider
    implements InputStreamProvider {
        private final File file;

        private FileInputProvider(File file) {
            this.file = file;
        }

        @Override
        public InputStream get() throws IOException {
            return new FileInputStream(this.file);
        }
    }

    private static interface InputStreamProvider {
        public InputStream get() throws IOException;
    }
}

