/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor.panel;

import com.dbeaver.ee.vqb.internal.ui.VQBMessages;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPresentation;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQueryElements;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQueryExpression;
import com.dbeaver.model.sql.vqb.model.VQBUtils;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDDiagram;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.controls.CustomComboBoxCellEditor;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.utils.CommonUtils;

abstract class VQBPanelQueryCondition
extends VQBPanelQueryExpression<Expression> {
    private static final Log log = Log.getLog(VQBPanelQueryCondition.class);

    protected VQBPanelQueryCondition(VQBEditorPresentation presentation) {
        super(presentation);
    }

    @Override
    protected void fillColumns(ViewerColumnController<Object, Expression> columnsController) {
        super.fillColumns(columnsController);
        columnsController.addColumn(VQBMessages.editor_panel_condition_columns_left_operand_name, VQBMessages.editor_panel_condition_columns_left_operand_description, 16384, true, false, element -> {
            Expression expr = this.getItemExpression(element);
            if (!VQBUtils.isCompoundExpression((Expression)expr)) {
                if (expr instanceof BinaryExpression) {
                    return ((BinaryExpression)expr).getLeftExpression().toString();
                }
                if (expr instanceof IsNullExpression) {
                    return ((IsNullExpression)expr).getLeftExpression().toString();
                }
                if (expr instanceof InExpression) {
                    return ((InExpression)expr).getLeftExpression().toString();
                }
            }
            return null;
        }, (EditingSupport)new ColumnEditingSupport());
        columnsController.addColumn(VQBMessages.editor_panel_condition_columns_operation_name, VQBMessages.editor_panel_condition_columns_operation_name, 16384, true, false, element -> {
            Expression expr = this.getItemExpression(element);
            if (!VQBUtils.isCompoundExpression((Expression)expr)) {
                return this.getExpressionOperator(expr);
            }
            return null;
        }, (EditingSupport)new OperationEditingSupport());
        columnsController.addColumn(VQBMessages.editor_panel_condition_columns_right_operand_name, VQBMessages.editor_panel_condition_columns_right_operand_description, 16384, true, false, element -> {
            Expression expr = this.getItemExpression(element);
            if (expr instanceof BinaryExpression && !VQBUtils.isCompoundExpression((Expression)expr)) {
                return ((BinaryExpression)expr).getRightExpression().toString();
            }
            if (expr instanceof InExpression) {
                return ((InExpression)expr).getRightItemsList().toString();
            }
            return null;
        }, (EditingSupport)new OperandEditingSupport());
    }

    @Override
    protected EditingSupport makeExpressionEditSupport() {
        return new ConditionExpressionEditingSupport();
    }

    @Override
    protected Expression getExpression(Expression element) {
        return element;
    }

    @Override
    protected void fillPanelContributions(IContributionManager contributionManager) {
        super.fillPanelContributions(contributionManager);
        contributionManager.add((IAction)new Action(VQBMessages.editor_panel_condition_action_add_column, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ROW_ADD)){

            public void run() {
                PlainSelect plainSelect = VQBPanelQueryCondition.this.getPlainSelect();
                if (plainSelect != null) {
                    Expression selectedExpression = (Expression)VQBPanelQueryCondition.this.getSelectedElement();
                    Expression parentExpression = (Expression)VQBPanelQueryCondition.this.getParentElement();
                    EqualsTo newExpression = new EqualsTo();
                    newExpression.setLeftExpression((Expression)new LongValue(1L));
                    newExpression.setRightExpression((Expression)new LongValue(1L));
                    if (selectedExpression == null) {
                        plainSelect.setWhere((Expression)newExpression);
                    } else if (parentExpression == null) {
                        AndExpression and = new AndExpression(selectedExpression, (Expression)newExpression);
                        plainSelect.setWhere((Expression)and);
                    } else if (parentExpression instanceof BinaryExpression) {
                        ((BinaryExpression)parentExpression).setRightExpression((Expression)new AndExpression(((BinaryExpression)parentExpression).getRightExpression(), (Expression)newExpression));
                    } else {
                        DBWorkbench.getPlatformUI().showError("Add condition error", "Cannot add child condition to '" + parentExpression + "'");
                        return;
                    }
                    VQBPanelQueryCondition.this.addNewElement(newExpression, 1);
                }
            }
        });
        contributionManager.add((IAction)new Action(VQBMessages.editor_panel_condition_action_remove, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ROW_DELETE)){

            public void run() {
                final PlainSelect plainSelect = VQBPanelQueryCondition.this.getPlainSelect();
                if (plainSelect == null) {
                    log.error((Object)"No plain select. Cannot remove condition.");
                    return;
                }
                final Expression selectedExpression = (Expression)VQBPanelQueryCondition.this.getSelectedElement();
                Expression parentExpression = (Expression)VQBPanelQueryCondition.this.getParentElement();
                if (selectedExpression != null) {
                    if (parentExpression == null) {
                        plainSelect.setWhere(null);
                    } else if (parentExpression instanceof BinaryExpression) {
                        parentExpression.accept((ExpressionVisitor)new ExpressionVisitorAdapter(){

                            public void visitBinaryExpression(BinaryExpression value) {
                                if (value.getRightExpression() == selectedExpression) {
                                    if (VQBUtils.isCompoundExpression((Expression)selectedExpression)) {
                                        if (selectedExpression instanceof BinaryExpression) {
                                            value.setRightExpression(((BinaryExpression)selectedExpression).getRightExpression());
                                        } else if (selectedExpression instanceof Parenthesis) {
                                            value.setRightExpression(((Parenthesis)selectedExpression).getExpression());
                                        }
                                    } else if (VQBUtils.isCompoundExpression((Expression)value)) {
                                        VQBUtils.replaceCompoundWithSingle((PlainSelect)plainSelect, (BinaryExpression)value, (Expression)value.getLeftExpression());
                                    }
                                } else if (value.getLeftExpression() == selectedExpression) {
                                    if (VQBUtils.isCompoundExpression((Expression)selectedExpression)) {
                                        if (selectedExpression instanceof BinaryExpression) {
                                            value.setLeftExpression(((BinaryExpression)selectedExpression).getLeftExpression());
                                        } else if (selectedExpression instanceof Parenthesis) {
                                            value.setLeftExpression(((Parenthesis)selectedExpression).getExpression());
                                        }
                                    } else if (VQBUtils.isCompoundExpression((Expression)value)) {
                                        VQBUtils.replaceCompoundWithSingle((PlainSelect)plainSelect, (BinaryExpression)value, (Expression)value.getRightExpression());
                                    }
                                } else {
                                    super.visitBinaryExpression(value);
                                }
                            }
                        });
                    } else {
                        DBWorkbench.getPlatformUI().showError("Remove condition error", "Cannot remove child condition from '" + parentExpression + "'");
                    }
                }
                VQBPanelQueryCondition.this.refreshDiagramAndStatement();
            }

            public boolean isEnabled() {
                return VQBPanelQueryCondition.this.getSelectedElement() != null;
            }
        });
    }

    private boolean updateConditionExpression(PlainSelect plainSelect, Expression oldExpression, Expression newExpression) {
        if (plainSelect.getWhere() == oldExpression) {
            plainSelect.setWhere(newExpression);
            return true;
        }
        return this.updateConditionExpression(plainSelect.getWhere(), oldExpression, newExpression);
    }

    private boolean updateConditionExpression(Expression parent, final Expression oldExpression, final Expression newExpression) {
        if (oldExpression.toString().equals(newExpression.toString())) {
            return true;
        }
        if (parent == null) {
            this.updateExpression(this.getPlainSelect(), newExpression);
            return true;
        }
        final boolean[] found = new boolean[1];
        parent.accept((ExpressionVisitor)new ExpressionVisitorAdapter(){

            public void visitBinaryExpression(BinaryExpression value) {
                super.visitBinaryExpression(value);
                if (value.getLeftExpression() == oldExpression) {
                    value.setLeftExpression(newExpression);
                    found[0] = true;
                } else if (value.getRightExpression() == oldExpression) {
                    value.setRightExpression(newExpression);
                    found[0] = true;
                }
            }
        });
        return found[0];
    }

    private String getExpressionOperator(Expression expr) {
        if (expr instanceof BinaryExpression) {
            return ((BinaryExpression)expr).getStringExpression();
        }
        if (expr instanceof IsNullExpression) {
            IsNullExpression isNull = (IsNullExpression)expr;
            return isNull.isNot() ? (isNull.isUseIsNull() ? "NOT ISNULL" : "IS NOT NULL") : (isNull.isUseIsNull() ? "ISNULL" : "IS NULL");
        }
        if (expr instanceof InExpression) {
            return "IN";
        }
        return null;
    }

    private Expression removeSubExpression(Expression root, Expression expr) {
        return root;
    }

    protected abstract void updateExpression(PlainSelect var1, Expression var2);

    private class ColumnEditingSupport
    extends ConditionEditingSupport {
        private ColumnEditingSupport() {
        }

        @Override
        protected List<String> getAvailableItems() {
            return VQBUtils.getAttributeNames((ERDDiagram)VQBPanelQueryCondition.this.presentation.getVQBEditor().getDiagram(), (boolean)false);
        }

        protected Object getValue(Object element) {
            Expression expr = VQBPanelQueryCondition.this.getItemExpression(element);
            if (expr instanceof BinaryExpression) {
                return ((BinaryExpression)expr).getLeftExpression().toString();
            }
            if (expr instanceof IsNullExpression) {
                return ((IsNullExpression)expr).getLeftExpression().toString();
            }
            if (expr instanceof InExpression) {
                return ((InExpression)expr).getLeftExpression().toString();
            }
            return null;
        }

        protected void setValue(Object element, Object value) {
            Expression expr = VQBPanelQueryCondition.this.getItemExpression(element);
            String exprText = CommonUtils.toString((Object)value);
            try {
                Expression newExpression;
                Expression expression = newExpression = CommonUtils.isEmpty((String)exprText) ? null : SQLSemanticProcessor.parseExpression((String)exprText);
                if (newExpression != null) {
                    if (expr instanceof BinaryExpression) {
                        if (CommonUtils.equalObjects((Object)CommonUtils.toString((Object)newExpression), (Object)CommonUtils.toString((Object)((BinaryExpression)expr).getLeftExpression()))) {
                            return;
                        }
                        ((BinaryExpression)expr).setLeftExpression(newExpression);
                    } else if (expr instanceof IsNullExpression) {
                        ((IsNullExpression)expr).setLeftExpression(newExpression);
                    } else if (expr instanceof InExpression) {
                        ((InExpression)expr).setLeftExpression(newExpression);
                    } else {
                        throw new DBException("Expression " + newExpression + " is not supported");
                    }
                    VQBPanelQueryCondition.this.refreshDiagramAndStatement();
                }
            }
            catch (Exception e) {
                DBWorkbench.getPlatformUI().showError("Parse error", "Error updating left expression", (Throwable)e);
                log.debug((Object)e);
            }
        }
    }

    private abstract class ConditionEditingSupport
    extends EditingSupport {
        public ConditionEditingSupport() {
            super((ColumnViewer)VQBPanelQueryCondition.this.elementViewer);
        }

        protected CellEditor getCellEditor(Object element) {
            CustomComboBoxCellEditor cellEditor = new CustomComboBoxCellEditor((ColumnViewer)VQBPanelQueryCondition.this.elementViewer, (Composite)VQBPanelQueryCondition.this.elementViewer.getTree(), new String[0], 4);
            List<String> attrNames = this.getAvailableItems();
            cellEditor.setItems(attrNames.toArray(new String[attrNames.size()]));
            TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)VQBPanelQueryCondition.this.presentation.getSQLEditor().getSite(), (Control)cellEditor.getControl());
            return cellEditor;
        }

        protected boolean canEdit(Object element) {
            Expression itemExpression = VQBPanelQueryCondition.this.getItemExpression(element);
            return !VQBUtils.isCompoundExpression((Expression)itemExpression);
        }

        protected abstract List<String> getAvailableItems();
    }

    private class ConditionExpressionEditingSupport
    extends VQBPanelQueryElements.ExpressionEditingSupport<Expression> {
        private ConditionExpressionEditingSupport() {
        }

        @Override
        protected boolean canEdit(Object element) {
            return false;
        }

        @Override
        protected Expression parseNewExpression(String text) throws DBCException {
            return CommonUtils.isEmpty((String)text) ? null : SQLSemanticProcessor.parseCondExpression((String)text);
        }

        @Override
        protected boolean updateElementExpression(Expression parent, Expression oldExpression, Expression newExpression) {
            return VQBPanelQueryCondition.this.updateConditionExpression(parent, oldExpression, newExpression);
        }
    }

    private class OperandEditingSupport
    extends ConditionEditingSupport {
        private OperandEditingSupport() {
        }

        @Override
        protected List<String> getAvailableItems() {
            return VQBUtils.getAttributeNames((ERDDiagram)VQBPanelQueryCondition.this.presentation.getVQBEditor().getDiagram(), (boolean)false);
        }

        protected Object getValue(Object element) {
            Expression expr = VQBPanelQueryCondition.this.getItemExpression(element);
            if (expr instanceof BinaryExpression) {
                return ((BinaryExpression)expr).getRightExpression().toString();
            }
            if (expr instanceof InExpression) {
                return ((InExpression)expr).getRightItemsList().toString();
            }
            return null;
        }

        protected void setValue(Object element, Object value) {
            Expression expr = VQBPanelQueryCondition.this.getItemExpression(element);
            try {
                String valueText = CommonUtils.toString((Object)value);
                if (expr instanceof InExpression) {
                    String newCond = String.valueOf(((InExpression)expr).getLeftExpression().toString()) + " IN " + valueText;
                    Expression newExpression = SQLSemanticProcessor.parseCondExpression((String)newCond, (boolean)false);
                    ((InExpression)expr).setRightItemsList(((InExpression)newExpression).getRightItemsList());
                } else {
                    Expression newExpression = SQLSemanticProcessor.parseExpression((String)valueText);
                    if (expr instanceof BinaryExpression) {
                        if (CommonUtils.equalObjects((Object)CommonUtils.toString((Object)newExpression), (Object)CommonUtils.toString((Object)((BinaryExpression)expr).getRightExpression()))) {
                            return;
                        }
                        ((BinaryExpression)expr).setRightExpression(newExpression);
                    } else {
                        throw new DBException("Expression " + newExpression + " is not supported");
                    }
                }
                VQBPanelQueryCondition.this.refreshDiagramAndStatement();
            }
            catch (Exception e) {
                DBWorkbench.getPlatformUI().showError("Parse error", "Error updating right expression", (Throwable)e);
                log.debug((Object)e);
            }
        }
    }

    private class OperationEditingSupport
    extends ConditionEditingSupport {
        private OperationEditingSupport() {
        }

        @Override
        protected List<String> getAvailableItems() {
            ArrayList<String> attrNames = new ArrayList<String>();
            DBCLogicalOperator[] dBCLogicalOperatorArray = DBCLogicalOperator.values();
            int n = dBCLogicalOperatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBCLogicalOperator op = dBCLogicalOperatorArray[n2];
                attrNames.add(op.getExpression());
                ++n2;
            }
            return attrNames;
        }

        protected Object getValue(Object element) {
            return VQBPanelQueryCondition.this.getExpressionOperator((Expression)element);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void setValue(Object element, Object value) {
            Expression expr = VQBPanelQueryCondition.this.getItemExpression(element);
            String operatorText = CommonUtils.toString((Object)value);
            try {
                String exprText;
                if ("in".equalsIgnoreCase(operatorText) || "not in".equalsIgnoreCase(operatorText)) {
                    exprText = expr instanceof BinaryExpression ? String.valueOf(((BinaryExpression)expr).getLeftExpression().toString()) + " " + operatorText + " (" + ((BinaryExpression)expr).getRightExpression().toString() + ")" : (expr instanceof IsNullExpression ? String.valueOf(((IsNullExpression)expr).getLeftExpression().toString()) + " " + operatorText + " (?)" : expr.toString());
                } else if ("is null".equalsIgnoreCase(operatorText) || "is not null".equalsIgnoreCase(operatorText)) {
                    if (expr instanceof BinaryExpression) {
                        exprText = String.valueOf(((BinaryExpression)expr).getLeftExpression().toString()) + " " + operatorText;
                    } else if (expr instanceof IsNullExpression) {
                        exprText = String.valueOf(((IsNullExpression)expr).getLeftExpression().toString()) + " " + operatorText;
                    } else {
                        if (!(expr instanceof InExpression)) throw new DBException("Unsupported expression type " + expr);
                        exprText = String.valueOf(((InExpression)expr).getLeftExpression().toString()) + " " + operatorText;
                    }
                } else if (expr instanceof BinaryExpression) {
                    exprText = String.valueOf(((BinaryExpression)expr).getLeftExpression().toString()) + " " + operatorText + " " + ((BinaryExpression)expr).getRightExpression().toString();
                } else if (expr instanceof IsNullExpression) {
                    exprText = String.valueOf(((IsNullExpression)expr).getLeftExpression().toString()) + " " + operatorText + " 1";
                } else {
                    if (!(expr instanceof InExpression)) throw new DBException("Unsupported expression type " + expr);
                    exprText = String.valueOf(((InExpression)expr).getLeftExpression().toString()) + " " + operatorText + " " + ((InExpression)expr).getRightItemsList().toString();
                }
                Expression newExpression = SQLSemanticProcessor.parseCondExpression((String)exprText, (boolean)false);
                if (!(newExpression instanceof BinaryExpression || newExpression instanceof IsNullExpression || newExpression instanceof InExpression)) {
                    throw new DBException("Operator " + operatorText + " is not supported");
                }
                if (!VQBPanelQueryCondition.this.updateConditionExpression(VQBPanelQueryCondition.this.getPlainSelect(), expr, newExpression)) {
                    throw new DBException("Can't replace condition [" + expr + "] with [" + newExpression + "]");
                }
                VQBPanelQueryCondition.this.refreshDiagramAndStatement();
                return;
            }
            catch (Exception e) {
                DBWorkbench.getPlatformUI().showError("Parse error", "Error updating expression operation", (Throwable)e);
                log.debug((Object)e);
            }
        }
    }
}

