/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor;

import com.dbeaver.ee.vqb.internal.ui.VQBUIActivator;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPart;
import com.dbeaver.model.sql.vqb.builder.VQBQueryInfo;
import com.dbeaver.model.sql.vqb.model.ERDJoin;
import com.dbeaver.model.sql.vqb.model.VQBUtils;
import java.util.Collection;
import java.util.List;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Database;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDAssociation;
import org.jkiss.dbeaver.erd.model.ERDContainer;
import org.jkiss.dbeaver.erd.model.ERDDiagram;
import org.jkiss.dbeaver.erd.model.ERDElement;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.erd.model.ERDUtils;
import org.jkiss.dbeaver.erd.ui.model.ERDContentProviderDecorated;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKeyColumn;
import org.jkiss.utils.CommonUtils;

public class VQBContentProvider
extends ERDContentProviderDecorated {
    private static final Log log = Log.getLog(VQBContentProvider.class);
    private final VQBEditorPart editorPart;

    public VQBContentProvider(VQBEditorPart editorPart) {
        this.editorPart = editorPart;
    }

    public boolean allowEntityDuplicates() {
        return true;
    }

    public void fillEntityFromObject(@NotNull DBRProgressMonitor monitor, @NotNull ERDDiagram diagram, List<ERDEntity> otherEntities, @NotNull ERDEntity erdEntity) {
        super.fillEntityFromObject(monitor, diagram, otherEntities, erdEntity);
        if (erdEntity.getUserData() == null) {
            PlainSelect plainSelect;
            DBSEntity entity = (DBSEntity)erdEntity.getObject();
            DBSCatalog catalog = (DBSCatalog)DBUtils.getParentOfType(DBSCatalog.class, (DBSObject)entity);
            DBSSchema schema = (DBSSchema)DBUtils.getParentOfType(DBSSchema.class, (DBSObject)entity);
            VQBQueryInfo queryInfo = this.editorPart.getQueryInfo();
            Table fromItem = new Table();
            fromItem.setName(DBUtils.getQuotedIdentifier((DBSObject)entity));
            boolean useFQN = VQBUIActivator.getDefault().getPreferences().getBoolean("vqb.use.name.fq");
            if (useFQN) {
                String entityName = DBUtils.getObjectFullName((DBPNamedObject)entity, (DBPEvaluationContext)DBPEvaluationContext.DML);
                if (schema != null) {
                    fromItem.setSchemaName(DBUtils.getQuotedIdentifier((DBSObject)schema));
                } else if (catalog != null) {
                    fromItem.setSchemaName(DBUtils.getQuotedIdentifier((DBSObject)catalog));
                }
                if (schema != null && catalog != null && entityName.startsWith(DBUtils.getQuotedIdentifier((DBSObject)catalog))) {
                    fromItem.setDatabase(new Database(DBUtils.getQuotedIdentifier((DBSObject)catalog)));
                }
            }
            if (VQBUIActivator.getDefault().getPreferences().getBoolean("vqb.add.aliases.always")) {
                SQLSyntaxManager syntaxManager = this.editorPart.getPresentation().getSQLEditor().getSyntaxManager();
                String entityAlias = VQBUtils.generateEntityAlias((ERDDiagram)diagram, otherEntities, (DBSEntity)entity, (SQLSyntaxManager)syntaxManager);
                erdEntity.setAlias(entityAlias);
                Alias alias = new Alias(entityAlias);
                alias.setUseAs(false);
                fromItem.setAlias(alias);
            }
            erdEntity.setUserData((Object)fromItem);
            PlainSelect plainSelect2 = plainSelect = queryInfo != null ? queryInfo.getPlainSelect() : null;
            if (plainSelect != null && plainSelect.getFromItem() == null) {
                if (entity.getDataSource() != this.editorPart.getDataSource()) {
                    return;
                }
                plainSelect.setFromItem((FromItem)fromItem);
                erdEntity.setPrimary(true);
            }
        }
    }

    public ERDAssociation createAutoAssociation(ERDContainer diagram, @NotNull DBSEntityAssociation association, @NotNull ERDEntity sourceEntity, @NotNull ERDEntity targetEntity, boolean reflect) {
        PlainSelect plainSelect;
        if (!VQBUIActivator.getDefault().getPreferences().getBoolean("vqb.auto.create.joins")) {
            return null;
        }
        if (sourceEntity.hasAssociationsWith((ERDElement)targetEntity) || targetEntity.hasAssociationsWith((ERDElement)sourceEntity)) {
            return null;
        }
        if (sourceEntity == targetEntity) {
            return null;
        }
        boolean reverseAssoc = false;
        if (targetEntity.isPrimary() || !CommonUtils.isEmpty((Collection)targetEntity.getReferences()) || !CommonUtils.isEmpty((Collection)targetEntity.getAssociations())) {
            if (!CommonUtils.isEmpty((Collection)sourceEntity.getReferences())) {
                log.debug((Object)("Both entities '" + sourceEntity.getName() + "' and '" + targetEntity.getName() + "' already participate in statement"));
                return null;
            }
            ERDEntity tmp = sourceEntity;
            sourceEntity = targetEntity;
            targetEntity = tmp;
            reverseAssoc = true;
        }
        ERDJoin erdJoin = new ERDJoin(sourceEntity, targetEntity, reflect);
        if (association instanceof DBSEntityReferrer) {
            try {
                List attrRefs = ((DBSEntityReferrer)association).getAttributeReferences((DBRProgressMonitor)new VoidProgressMonitor());
                if (!CommonUtils.isEmpty((Collection)attrRefs)) {
                    for (DBSEntityAttributeRef attrRef : attrRefs) {
                        if (!(attrRef instanceof DBSTableForeignKeyColumn)) continue;
                        DBSEntityAttribute targetAttr = ((DBSTableForeignKeyColumn)attrRef).getReferencedColumn();
                        DBSEntityAttribute sourceAttr = attrRef.getAttribute();
                        if (reverseAssoc) {
                            DBSEntityAttribute tmp = targetAttr;
                            targetAttr = sourceAttr;
                            sourceAttr = tmp;
                        }
                        if (sourceAttr == null || targetAttr == null) continue;
                        ERDEntityAttribute erdSourceAttr = ERDUtils.getAttributeByModel((ERDEntity)sourceEntity, (DBSEntityAttribute)sourceAttr);
                        ERDEntityAttribute erdTargetAttr = ERDUtils.getAttributeByModel((ERDEntity)targetEntity, (DBSEntityAttribute)targetAttr);
                        if (erdSourceAttr == null || erdTargetAttr == null) continue;
                        erdJoin.addCondition(erdSourceAttr, erdTargetAttr);
                    }
                }
            }
            catch (DBException e) {
                log.error((Object)"Error resolving ERD association attributes", (Throwable)e);
            }
        }
        if ((plainSelect = this.editorPart.getQueryInfo().getPlainSelect()) != null) {
            Join join = VQBUtils.findEntityJoin((ERDDiagram)this.editorPart.getDiagram(), (PlainSelect)plainSelect, null, (ERDEntity)targetEntity);
            if (join == null) {
                join = erdJoin.createStatementJoin();
                VQBUtils.getQueryJoins((PlainSelect)plainSelect).add(join);
            } else {
                erdJoin.updateStatementJoin(join);
            }
            List plainSelectJoins = plainSelect.getJoins();
            if (!CommonUtils.isEmpty((Collection)plainSelectJoins) && plainSelectJoins.size() > 1) {
                Table fromItemTable = null;
                FromItem fromItem = plainSelect.getFromItem();
                if (fromItem instanceof Table) {
                    fromItemTable = (Table)fromItem;
                }
                int i = 0;
                while (i < plainSelectJoins.size() - 1) {
                    Join listJoin = (Join)plainSelectJoins.get(i);
                    Expression onExpression = VQBUtils.getJoinOnExpression((Join)listJoin);
                    if (onExpression != null) {
                        Expression leftExpression;
                        Table leftTable = null;
                        if (onExpression instanceof EqualsTo && (leftExpression = ((EqualsTo)onExpression).getLeftExpression()) instanceof Column) {
                            leftTable = ((Column)leftExpression).getTable();
                        }
                        if (leftTable == null || fromItemTable == null || !VQBUtils.equalTables(leftTable, (Table)fromItemTable)) {
                            if (i == 0) {
                                plainSelectJoins.remove(listJoin);
                                plainSelectJoins.add(listJoin);
                            } else {
                                boolean tableInJoin = false;
                                int j = 0;
                                while (j <= i) {
                                    if (VQBUtils.equalTables((Table)leftTable, (Table)((Table)((Join)plainSelectJoins.get(j)).getRightItem()))) {
                                        tableInJoin = true;
                                        break;
                                    }
                                    ++j;
                                }
                                if (!tableInJoin) {
                                    plainSelectJoins.remove(listJoin);
                                    plainSelectJoins.add(listJoin);
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        return erdJoin;
    }
}

