/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.commands;

import com.dbeaver.ee.vqb.ui.commands.VQBDiagramCommand;
import com.dbeaver.model.sql.vqb.builder.VQBQueryInfo;
import com.dbeaver.model.sql.vqb.model.ERDJoin;
import com.dbeaver.model.sql.vqb.model.VQBUtils;
import java.util.List;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.jkiss.dbeaver.erd.model.ERDAssociation;
import org.jkiss.dbeaver.erd.model.ERDDiagram;
import org.jkiss.dbeaver.erd.model.ERDElement;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.ui.command.AssociationCreateCommand;
import org.jkiss.utils.CommonUtils;

public class JoinCreateCommand
extends AssociationCreateCommand
implements VQBDiagramCommand {
    private final ERDDiagram entityDiagram;
    private final VQBQueryInfo queryInfo;

    public JoinCreateCommand(ERDDiagram entityDiagram, VQBQueryInfo queryInfo) {
        this.entityDiagram = entityDiagram;
        this.queryInfo = queryInfo;
    }

    protected ERDAssociation createAssociation(ERDElement<?> sourceEntity, ERDElement<?> targetEntity, boolean reflect) {
        if (sourceEntity instanceof ERDEntity && targetEntity instanceof ERDEntity) {
            ERDJoin erdJoin = new ERDJoin((ERDEntity)sourceEntity, (ERDEntity)targetEntity, reflect);
            if (this.getSourceAttribute() != null && this.getTargetAttribute() != null) {
                erdJoin.addCondition(this.getSourceAttribute(), this.getTargetAttribute());
            }
            return erdJoin;
        }
        return null;
    }

    public boolean canExecute() {
        if (this.getSourceAttribute() == null || this.getTargetAttribute() == null || CommonUtils.equalObjects((Object)this.getSourceAttribute(), (Object)this.getTargetAttribute())) {
            return false;
        }
        return this.getSourceEntity() instanceof ERDEntity && this.getTargetEntity() instanceof ERDEntity;
    }

    public void execute() {
        this.association = this.execute(false);
    }

    public void undo() {
        super.undo();
        this.execute(true);
        this.association = null;
    }

    private ERDJoin execute(boolean undo) {
        ERDJoin erdJoin = null;
        PlainSelect plainSelect = this.queryInfo.getPlainSelect();
        if (plainSelect != null) {
            if (!undo) {
                Join join = VQBUtils.findEntityJoin((ERDDiagram)this.entityDiagram, (PlainSelect)plainSelect, (ERDEntity)((ERDEntity)this.sourceEntity), (ERDEntity)((ERDEntity)this.targetEntity));
                if (join != null) {
                    join.setInner(true);
                    erdJoin = VQBUtils.findERDJoin((ERDDiagram)this.entityDiagram, (Join)join);
                    if (erdJoin == null) {
                        erdJoin = new ERDJoin((ERDEntity)this.sourceEntity, (ERDEntity)this.targetEntity, true);
                        erdJoin.setUserData((Object)join);
                    }
                    erdJoin.addCondition(this.getSourceAttribute(), this.getTargetAttribute());
                    erdJoin.updateStatementJoin(join);
                } else {
                    erdJoin = new ERDJoin((ERDEntity)this.sourceEntity, (ERDEntity)this.targetEntity, true);
                    erdJoin.addCondition(this.getSourceAttribute(), this.getTargetAttribute());
                    join = erdJoin.createStatementJoin();
                    VQBUtils.getQueryJoins((PlainSelect)plainSelect).add(join);
                }
            } else {
                erdJoin = (ERDJoin)this.association;
                Join join = (Join)erdJoin.getUserData();
                List joins = plainSelect.getJoins();
                if (joins != null) {
                    joins.remove(join);
                }
            }
        }
        return erdJoin;
    }
}

