/*
 * Decompiled with CFR 0.152.
 */
package com.edb.replication.fluent;

import com.edb.core.BaseConnection;
import com.edb.core.ReplicationProtocol;
import com.edb.replication.PGReplicationStream;
import com.edb.replication.fluent.ChainedStreamBuilder;
import com.edb.replication.fluent.logical.ChainedLogicalStreamBuilder;
import com.edb.replication.fluent.logical.LogicalReplicationOptions;
import com.edb.replication.fluent.logical.LogicalStreamBuilder;
import com.edb.replication.fluent.logical.StartLogicalReplicationCallback;
import com.edb.replication.fluent.physical.ChainedPhysicalStreamBuilder;
import com.edb.replication.fluent.physical.PhysicalReplicationOptions;
import com.edb.replication.fluent.physical.PhysicalStreamBuilder;
import com.edb.replication.fluent.physical.StartPhysicalReplicationCallback;
import java.sql.SQLException;

public class ReplicationStreamBuilder
implements ChainedStreamBuilder {
    private final BaseConnection baseConnection;

    public ReplicationStreamBuilder(BaseConnection connection) {
        this.baseConnection = connection;
    }

    @Override
    public ChainedLogicalStreamBuilder logical() {
        return new LogicalStreamBuilder(new StartLogicalReplicationCallback(){

            @Override
            public PGReplicationStream start(LogicalReplicationOptions options) throws SQLException {
                ReplicationProtocol protocol = ReplicationStreamBuilder.this.baseConnection.getReplicationProtocol();
                return protocol.startLogical(options);
            }
        });
    }

    @Override
    public ChainedPhysicalStreamBuilder physical() {
        return new PhysicalStreamBuilder(new StartPhysicalReplicationCallback(){

            @Override
            public PGReplicationStream start(PhysicalReplicationOptions options) throws SQLException {
                ReplicationProtocol protocol = ReplicationStreamBuilder.this.baseConnection.getReplicationProtocol();
                return protocol.startPhysical(options);
            }
        });
    }
}

