/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.metrics;

import com.couchbase.client.core.event.CouchbaseEvent;
import com.couchbase.client.core.event.EventBus;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.metrics.MetricsCollector;
import com.couchbase.client.core.metrics.MetricsCollectorConfig;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action1;

public abstract class AbstractMetricsCollector
implements MetricsCollector {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(MetricsCollector.class);
    private final MetricsCollectorConfig config;
    private final Subscription subscription;
    private final boolean isEnabled;
    private final Scheduler scheduler;
    private final EventBus eventBus;

    protected AbstractMetricsCollector(final EventBus eventBus, Scheduler scheduler, MetricsCollectorConfig config) {
        this.config = config;
        this.scheduler = scheduler;
        this.eventBus = eventBus;
        this.isEnabled = config.emitFrequency() > 0L;
        this.subscription = config.emitFrequency() > 0L ? Observable.interval((long)config.emitFrequency(), (TimeUnit)config.emitFrequencyUnit(), (Scheduler)scheduler).subscribe((Action1)new Action1<Long>(){

            public void call(Long ignored) {
                CouchbaseEvent event = AbstractMetricsCollector.this.generateCouchbaseEvent();
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Emitting Metric to EventBus: {}", (Object)event);
                }
                eventBus.publish(event);
            }
        }) : null;
    }

    protected abstract CouchbaseEvent generateCouchbaseEvent();

    @Override
    public MetricsCollectorConfig config() {
        return this.config;
    }

    @Override
    public boolean shutdown() {
        if (this.subscription == null) {
            return true;
        }
        if (!this.subscription.isUnsubscribed()) {
            this.subscription.unsubscribe();
        }
        return true;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void triggerEmit() {
        if (!this.isEnabled()) {
            return;
        }
        Observable.just((Object)this.generateCouchbaseEvent()).subscribeOn(this.scheduler).subscribe((Action1)new Action1<CouchbaseEvent>(){

            public void call(CouchbaseEvent event) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.trace("Manually Triggering Metric Emit to EventBus: {}", (Object)event);
                }
                AbstractMetricsCollector.this.eventBus.publish(event);
            }
        });
    }
}

