/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.snowflake.model;

import com.dbeaver.db.snowflake.model.SnowflakeSchema;
import com.dbeaver.db.snowflake.model.SnowflakeUniqueKey;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class SnowflakeTable
extends GenericTable
implements DBPObjectStatistics {
    private long tableSize = -1L;
    private Date createTime;
    private Date lastAlter;
    private String clusteringKey;

    public SnowflakeTable(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        super(container, tableName, tableType, dbResult);
        if (dbResult != null) {
            this.tableSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"BYTES");
            this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATED");
            this.lastAlter = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_ALTERED");
            this.clusteringKey = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CLUSTERING_KEY");
        }
    }

    @Property(viewable=true, order=6)
    public Date getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=true, order=7)
    public Date getLastAlter() {
        return this.lastAlter;
    }

    @Property(viewable=true, order=8)
    public String getClusteringKey() {
        return this.clusteringKey;
    }

    @Association
    public Collection<SnowflakeUniqueKey> getUniqueKeys(DBRProgressMonitor monitor) throws DBException {
        return ((SnowflakeSchema)this.getSchema()).getUniqueConstraintCache().getTypedObjects(monitor, (DBSObject)this.getSchema(), (DBSObject)this, SnowflakeUniqueKey.class);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        ((SnowflakeSchema)this.getSchema()).getUniqueConstraintCache().clearObjectCache((DBSObject)this);
        return super.refreshObject(monitor);
    }

    public boolean hasStatistics() {
        return this.tableSize != -1L;
    }

    public long getStatObjectSize() {
        return this.tableSize;
    }

    @Nullable
    public DBPPropertySource getStatProperties() {
        return null;
    }
}

