/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.snowflake.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class SnowflakeSequenceManager
extends SQLObjectEditor<GenericSequence, GenericSchema>
implements DBEObjectRenamer<GenericSequence> {
    public boolean canCreateObject(Object container) {
        return false;
    }

    protected GenericSequence createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) throws DBException {
        throw new IllegalStateException("Not implemented");
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) throws DBException {
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) throws DBException {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop sequence", "DROP SEQUENCE " + ((GenericSequence)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, GenericSequence> getObjectsCache(GenericSequence object) {
        DBSObject parentObject = object.getParentObject();
        if (parentObject instanceof GenericStructContainer) {
            return ((GenericStructContainer)parentObject).getSequenceCache();
        }
        return null;
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        GenericSequence sequence = (GenericSequence)command.getObject();
        if (command.hasProperty((Object)"incrementBy")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Alter sequence", "ALTER SEQUENCE " + sequence.getFullyQualifiedName(DBPEvaluationContext.DDL) + " SET INCREMENT BY = " + sequence.getIncrementBy()));
        }
    }

    protected void addObjectExtraActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.NestedObjectCommand<GenericSequence, SQLObjectEditor.PropertyHandler> command, Map<String, Object> options) {
        GenericSequence sequence = (GenericSequence)command.getObject();
        if (command.hasProperty((Object)"description")) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment sequence", "ALTER SEQUENCE " + sequence.getFullyQualifiedName(DBPEvaluationContext.DDL) + " SET COMMENT = " + SQLUtils.quoteString((DBSObject)sequence, (String)CommonUtils.notEmpty((String)sequence.getDescription()))));
        }
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull GenericSequence object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        GenericSequence sequence = (GenericSequence)command.getObject();
        GenericDataSource dataSource = sequence.getDataSource();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename sequence", "ALTER SEQUENCE " + this.getFullSequenceName(sequence, DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getOldName())) + " RENAME TO " + this.getFullSequenceName(sequence, DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getNewName()))));
    }

    private String getFullSequenceName(@NotNull GenericSequence sequence, String sequenceName) {
        StringBuilder fullName = new StringBuilder(sequenceName);
        DBSObject schema = sequence.getParentObject();
        if (schema != null) {
            fullName.insert(0, String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)schema)) + ".");
            DBSObject catalog = schema.getParentObject();
            if (catalog != null) {
                fullName.insert(0, String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)catalog)) + ".");
            }
        }
        return fullName.toString();
    }
}

