/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.teradata.sqlgenerator;

import liquibase.database.Database;
import liquibase.ext.teradata.database.TeradataDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.DropPrimaryKeyGenerator;
import liquibase.statement.core.DropPrimaryKeyStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.PrimaryKey;

public class DropPrimaryKeyGeneratorTeradata
extends DropPrimaryKeyGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(DropPrimaryKeyStatement statement, Database database) {
        return database instanceof TeradataDatabase;
    }

    public Sql[] generateSql(DropPrimaryKeyStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String schemaName = statement.getSchemaName();
        return new Sql[]{new UnparsedSql("DROP INDEX " + database.escapeObjectName(statement.getConstraintName(), PrimaryKey.class) + " ON " + database.escapeTableName(statement.getCatalogName(), schemaName, statement.getTableName()), new DatabaseObject[0])};
    }
}

