/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.teradata.sqlgenerator;

import java.util.ArrayList;
import java.util.Arrays;
import liquibase.change.ColumnConfig;
import liquibase.database.Database;
import liquibase.database.core.SybaseASADatabase;
import liquibase.database.core.SybaseDatabase;
import liquibase.datatype.DataTypeFactory;
import liquibase.datatype.LiquibaseDataType;
import liquibase.datatype.core.DateTimeType;
import liquibase.datatype.core.DateType;
import liquibase.datatype.core.TimeType;
import liquibase.ext.teradata.database.TeradataDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.AddColumnGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddColumnStatement;
import liquibase.statement.core.AddPrimaryKeyStatement;
import liquibase.statement.core.AddUniqueConstraintStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;

public class AddColumnGeneratorTeradata
extends AddColumnGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(AddColumnStatement statement, Database database) {
        return database instanceof TeradataDatabase;
    }

    public Sql[] generateSql(AddColumnStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String alterTable = "ALTER TABLE " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()) + " ADD " + database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getColumnName()) + " " + DataTypeFactory.getInstance().fromDescription(statement.getColumnType() + (statement.isAutoIncrement() ? "{autoIncrement:true}" : ""), database).toDatabaseDataType(database);
        if (statement.isAutoIncrement() && database.supportsAutoIncrement()) {
            alterTable = alterTable + " " + database.getAutoIncrementClause(null, null, null, Boolean.valueOf(true));
        }
        if (!statement.isNullable()) {
            alterTable = alterTable + " NOT NULL";
        } else if (database instanceof SybaseDatabase || database instanceof SybaseASADatabase) {
            alterTable = alterTable + " NULL";
        }
        if (statement.getDefaultValue() != null) {
            alterTable = alterTable + " DEFAULT ";
            LiquibaseDataType defaultValueType = DataTypeFactory.getInstance().fromDescription(statement.getColumnType() + (statement.isAutoIncrement() ? "{autoIncrement:true}" : ""), database);
            alterTable = alterTable + (defaultValueType instanceof DateTimeType ? " TIMESTAMP " : (defaultValueType instanceof DateType ? " DATE " : (defaultValueType instanceof TimeType ? " TIME " : "")));
            alterTable = alterTable + DataTypeFactory.getInstance().fromObject(statement.getDefaultValue(), database).objectToSql(statement.getDefaultValue(), database);
        }
        ArrayList<Object> returnSql = new ArrayList<Object>();
        returnSql.add(new UnparsedSql(alterTable, new DatabaseObject[]{new Column().setRelation(new Table().setName(statement.getTableName()).setSchema(new Schema(statement.getCatalogName(), statement.getSchemaName())).setName(statement.getColumnName()))}));
        if (statement.isPrimaryKey()) {
            returnSql.addAll(Arrays.asList(SqlGeneratorFactory.getInstance().generateSql((SqlStatement)new AddPrimaryKeyStatement(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getColumnName(), null), database)));
        }
        if (statement.isUnique()) {
            returnSql.addAll(Arrays.asList(SqlGeneratorFactory.getInstance().generateSql((SqlStatement)new AddUniqueConstraintStatement(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), new ColumnConfig[]{new ColumnConfig().setName(statement.getColumnName())}, null), database)));
        }
        this.addForeignKeyStatements(statement, database, returnSql);
        return returnSql.toArray(new Sql[returnSql.size()]);
    }
}

