/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchdb.model;

import com.dbeaver.db.couchdb.exec.CouchDBDatabaseStatement;
import com.dbeaver.db.couchdb.exec.CouchDBExecutionContext;
import com.dbeaver.db.couchdb.exec.CouchDBInsertStatement;
import com.dbeaver.db.couchdb.exec.CouchDBResultSet;
import com.dbeaver.db.couchdb.exec.CouchDBSession;
import com.dbeaver.db.couchdb.exec.CouchDBUpdateStatement;
import com.dbeaver.db.couchdb.model.CouchDBDataSource;
import com.dbeaver.ee.model.document.DBAbstractDocumentContainer;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBFetchProgress;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPExclusiveResource;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.SimpleExclusiveLock;
import org.jkiss.dbeaver.model.impl.data.ExecuteBatchImpl;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.utils.ArrayUtils;
import org.lightcouch.CouchDbClientBase;

public class CouchDBDatabase
extends DBAbstractDocumentContainer<CouchDBDataSource>
implements DBSInstance,
DBSCatalog,
DBPSaveableObject,
DBPNamedObject2,
DBPRefreshableObject,
DBSDataManipulator {
    private static final Log log = Log.getLog(CouchDBDatabase.class);
    private final DBPExclusiveResource exclusiveLock = new SimpleExclusiveLock();
    private final CouchDBExecutionContext executionContext;
    private boolean persisted;
    private volatile String dbName;

    public CouchDBDatabase(DBRProgressMonitor monitor, CouchDBDataSource dataSource, String dbName, boolean persisted) throws DBCException {
        super((DBPDataSource)dataSource);
        this.dbName = dbName;
        this.persisted = persisted;
        this.executionContext = new CouchDBExecutionContext(this, "CouchDB Database '" + dbName + "' Connection");
        this.executionContext.connect(monitor);
    }

    public CouchDbClientBase getClient() {
        return this.executionContext.getClient();
    }

    @NotNull
    public DBCExecutionContext getDefaultContext(DBRProgressMonitor monitor, boolean meta) {
        return this.executionContext;
    }

    @NotNull
    public DBCExecutionContext[] getAllContexts() {
        return new DBCExecutionContext[]{this.executionContext};
    }

    @NotNull
    public DBCExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor monitor, @NotNull String purpose, @Nullable DBCExecutionContext initFrom) throws DBException {
        return this.executionContext;
    }

    public void shutdown(DBRProgressMonitor monitor) {
        this.executionContext.close();
    }

    @NotNull
    public DBPExclusiveResource getExclusiveLock() {
        return this.exclusiveLock;
    }

    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return this.dbName;
    }

    public void setName(String newName) {
        this.dbName = newName;
    }

    @Property(order=20)
    public URI getBaseUri() {
        return this.getClient().getBaseUri();
    }

    @Property(order=21)
    public URI getDBUri() {
        return this.getClient().getDBUri();
    }

    @Property(viewable=true, order=30)
    public long getDocCount() {
        return this.executionContext.getDbInfo().getDocCount();
    }

    @Property(viewable=false, order=31)
    public String getDocDelCount() {
        return this.executionContext.getDbInfo().getDocDelCount();
    }

    @Property(viewable=false, order=32)
    public String getUpdateSeq() {
        return this.executionContext.getDbInfo().getUpdateSeq();
    }

    @Property(viewable=false, order=33)
    public Object getPurgeSeq() {
        return this.executionContext.getDbInfo().getPurgeSeq();
    }

    @Property(viewable=false, order=34)
    public boolean isCompactRunning() {
        return this.executionContext.getDbInfo().isCompactRunning();
    }

    @Property(viewable=true, order=35)
    public long getDiskSize() {
        return this.executionContext.getDbInfo().getDiskSize();
    }

    @Property(viewable=false, order=36)
    public Date getInstanceStartTime() {
        return new Date(this.executionContext.getDbInfo().getInstanceStartTime());
    }

    @Property(viewable=false, order=37)
    public int getDiskFormatVersion() {
        return this.executionContext.getDbInfo().getDiskFormatVersion();
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return ((CouchDBDataSource)this.dataSource).getContainer();
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public String toString() {
        return this.getName();
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this;
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.TABLE;
    }

    public String[] getSupportedFeatures() {
        return new String[]{"data.select", "data.count", "data.filter", "data.insert", "data.update", "data.delete"};
    }

    @NotNull
    public DBCStatistics readData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
        DBCStatistics statistics = new DBCStatistics();
        System.currentTimeMillis();
        DBRProgressMonitor monitor = session.getProgressMonitor();
        monitor.beginTask("Read database documents", 1);
        monitor.subTask("Query database '" + this.getName() + "' documents");
        try {
            DBFetchProgress fetchProgress = new DBFetchProgress(session.getProgressMonitor());
            Throwable throwable = null;
            Object var16_14 = null;
            try (CouchDBDatabaseStatement dbStat = new CouchDBDatabaseStatement((CouchDBSession)session, this, firstRow, maxRows, dataFilter);){
                dbStat.setStatementSource(source);
                if (dbStat.executeStatement()) {
                    Throwable throwable2 = null;
                    Object var19_19 = null;
                    try (CouchDBResultSet resultSet = dbStat.openResultSet();){
                        dataReceiver.fetchStart(session, (DBCResultSet)resultSet, firstRow, maxRows);
                        while (resultSet.nextRow() && !monitor.isCanceled()) {
                            dataReceiver.fetchRow(session, (DBCResultSet)resultSet);
                            fetchProgress.monitorRowFetch();
                        }
                        dataReceiver.fetchEnd(session, (DBCResultSet)resultSet);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                fetchProgress.dumpStatistics(statistics);
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        finally {
            monitor.done();
        }
        return statistics;
    }

    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) throws DBCException {
        return this.executionContext.getClient().context().info().getDocCount();
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch insertData(@NotNull DBCSession session, @NotNull DBSAttributeBase[] attributes, @Nullable DBDDataReceiver keysReceiver, final @NotNull DBCExecutionSource source, Map<String, Object> options) throws DBCException {
        final CouchDBSession mongoSession = (CouchDBSession)session;
        return new ExecuteBatchImpl(attributes, null, false){

            @NotNull
            protected DBCStatement prepareStatement(@NotNull DBCSession session, DBDValueHandler[] handlers, Object[] attributeValues, Map<String, Object> options) throws DBCException {
                CouchDBInsertStatement statement = new CouchDBInsertStatement(mongoSession, CouchDBDatabase.this, this.attributes, attributeValues);
                statement.setStatementSource(source);
                return statement;
            }

            protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
                ((CouchDBInsertStatement)statement).setRowValues(attributeValues);
            }
        };
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch updateData(@NotNull DBCSession session, final @NotNull DBSAttributeBase[] updateAttributes, final @NotNull DBSAttributeBase[] keyAttributes, @Nullable DBDDataReceiver keysReceiver, final @NotNull DBCExecutionSource source) throws DBCException {
        final CouchDBSession cdbSession = (CouchDBSession)session;
        return new ExecuteBatchImpl((DBSAttributeBase[])ArrayUtils.concatArrays((Object[])updateAttributes, (Object[])keyAttributes), null, false){

            @NotNull
            protected DBCStatement prepareStatement(@NotNull DBCSession session, DBDValueHandler[] handlers, Object[] attributeValues, Map<String, Object> options) throws DBCException {
                CouchDBUpdateStatement statement = new CouchDBUpdateStatement(cdbSession, CouchDBDatabase.this, updateAttributes, keyAttributes, attributeValues);
                statement.setStatementSource(source);
                return statement;
            }

            protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
                ((CouchDBUpdateStatement)statement).setRowValues(attributeValues);
            }
        };
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch deleteData(@NotNull DBCSession session, @NotNull DBSAttributeBase[] keyAttributes, @NotNull DBCExecutionSource source) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    @NotNull
    public DBCStatistics truncateData(@NotNull DBCSession session, @NotNull DBCExecutionSource source) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Nullable
    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return null;
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return DBSObject.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }
}

