/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchdb.exec;

import com.dbeaver.db.couchdb.exec.CouchDBSession;
import com.dbeaver.db.couchdb.model.CouchDBDataSource;
import com.dbeaver.db.couchdb.model.CouchDBDatabase;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.utils.CommonUtils;
import org.lightcouch.CouchDbClient;
import org.lightcouch.CouchDbClientBase;
import org.lightcouch.CouchDbInfo;

public class CouchDBExecutionContext
extends AbstractExecutionContext<CouchDBDataSource>
implements DBCExecutionContextDefaults<CouchDBDatabase, DBSSchema> {
    private static final Log log = Log.getLog(CouchDBExecutionContext.class);
    private CouchDBDatabase database;
    private CouchDbClientBase client;
    private CouchDbInfo dbInfo;

    public CouchDBExecutionContext(CouchDBDatabase database, String purpose) {
        super((DBPDataSource)((CouchDBDataSource)database.getDataSource()), purpose);
        this.database = database;
    }

    public CouchDbClientBase getClient() {
        return this.client;
    }

    public CouchDbInfo getDbInfo() {
        return this.dbInfo;
    }

    public void connect(DBRProgressMonitor monitor) throws DBCException {
        this.connect(monitor, null, null);
    }

    public void connect(DBRProgressMonitor monitor, Boolean autoCommit, @Nullable Integer txnLevel) throws DBCException {
        DBExecUtils.startContextInitiation((DBPDataSourceContainer)((CouchDBDataSource)this.dataSource).getContainer());
        try {
            try {
                monitor.subTask("Open CouchDB session");
                DBPConnectionConfiguration configuration = ((CouchDBDataSource)this.dataSource).getContainer().getActualConnectionConfiguration();
                String nodeAddress = configuration.getHostName();
                String nodePort = configuration.getHostPort();
                String userName = configuration.getUserName();
                String userPassword = configuration.getUserPassword();
                monitor.subTask("Initialize LightCouch client");
                this.client = new CouchDbClient(this.database.getName(), false, "http", nodeAddress, CommonUtils.toInt((Object)nodePort), userName, userPassword);
                monitor.subTask("Get database info");
                this.dbInfo = this.client.context().info();
                super.initContextBootstrap(monitor, true);
            }
            catch (Exception e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)this);
            }
        }
        finally {
            DBExecUtils.finishContextInitiation((DBPDataSourceContainer)((CouchDBDataSource)this.dataSource).getContainer());
        }
    }

    @NotNull
    public CouchDBSession openSession(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionPurpose purpose, @NotNull String taskTitle) {
        return new CouchDBSession(monitor, purpose, taskTitle, this);
    }

    public void checkContextAlive(DBRProgressMonitor monitor) throws DBException {
    }

    public DBSInstance getOwnerInstance() {
        return this.database;
    }

    public boolean isConnected() {
        return this.client != null;
    }

    @NotNull
    public DBCExecutionContext.InvalidateResult invalidateContext(@NotNull DBRProgressMonitor monitor, boolean closeOnFailure) throws DBException {
        return DBCExecutionContext.InvalidateResult.RECONNECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.client = null;
        CouchDBExecutionContext couchDBExecutionContext = this;
        synchronized (couchDBExecutionContext) {
            super.closeContext();
        }
    }

    @Nullable
    public DBCExecutionContextDefaults getContextDefaults() {
        return this;
    }

    public CouchDBDatabase getDefaultCatalog() {
        return this.database;
    }

    public DBSSchema getDefaultSchema() {
        return null;
    }

    public boolean supportsCatalogChange() {
        return false;
    }

    public boolean supportsSchemaChange() {
        return false;
    }

    public void setDefaultCatalog(DBRProgressMonitor monitor, CouchDBDatabase catalog, DBSSchema schema) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public void setDefaultSchema(DBRProgressMonitor monitor, DBSSchema schema) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public boolean refreshDefaults(DBRProgressMonitor monitor, boolean useBootstrapSettings) throws DBException {
        return false;
    }
}

