/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.internal.ui.preferences;

import com.dbeaver.ee.runtime.core.DBeaverEnterprisePreferences;
import com.dbeaver.ee.runtime.internal.ui.UiMessages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageDatabaseSecurity
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "com.dbeaver.ee.runtime.ui.preferencePages.page.security";
    public static final String EQUINOX_SECURITY_PAGE_ID = "org.eclipse.equinox.security.ui.storage";
    private Button useSecurePreferences;
    private Button useBouncyCastle;

    public PrefPageDatabaseSecurity() {
        this.setPreferenceStore((IPreferenceStore)new PreferenceStoreDelegate(DBeaverEnterprisePreferences.getPreferences()));
    }

    public void init(IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        Group preferencesGroup = UIUtils.createControlGroup((Composite)composite, (String)UiMessages.PrefPageDatabaseSecurity_group_security, (int)1, (int)0, (int)0);
        this.useSecurePreferences = UIUtils.createCheckbox((Composite)preferencesGroup, (String)UiMessages.PrefPageDatabaseSecurity_checkbox_storage, (boolean)false);
        new Label((Composite)preferencesGroup, 0).setText(UiMessages.PrefPageDatabaseSecurity_text_storage);
        PreferenceLinkArea storageLinkArea = new PreferenceLinkArea((Composite)preferencesGroup, 0, EQUINOX_SECURITY_PAGE_ID, UiMessages.PrefPageDatabaseSecurity_link_storage, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        storageLinkArea.getControl().setLayoutData((Object)new GridData(768));
        Group masterPasswordGroup = UIUtils.createControlGroup((Composite)composite, (String)UiMessages.PrefPageDatabaseSecurity_group_provider, (int)1, (int)0, (int)0);
        this.useBouncyCastle = UIUtils.createCheckbox((Composite)masterPasswordGroup, (String)UiMessages.PrefPageDatabaseSecurity_check_bouncy_castle, (boolean)false);
        UIUtils.createLabel((Composite)masterPasswordGroup, (String)UiMessages.PrefPageDatabaseSecurity_text_bouncy_castle);
        this.performDefaults();
        return composite;
    }

    protected void performDefaults() {
        DBPPreferenceStore store = DBeaverEnterprisePreferences.getPreferences();
        this.useSecurePreferences.setSelection(store.getBoolean("security.secure.password.storage"));
        this.useBouncyCastle.setSelection(DBWorkbench.getPlatform().getPreferenceStore().getBoolean("security.jce.bc"));
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBeaverEnterprisePreferences.getPreferences();
        boolean oldUseSecureStore = store.getBoolean("security.secure.password.storage");
        boolean newUseSecureStore = this.useSecurePreferences.getSelection();
        store.setValue("security.secure.password.storage", newUseSecureStore);
        DBWorkbench.getPlatform().getPreferenceStore().setValue("security.jce.bc", this.useBouncyCastle.getSelection());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        if (oldUseSecureStore != newUseSecureStore) {
            for (DBPDataSourceRegistry registry : DBUtils.getAllRegistries((boolean)true)) {
                registry.flushConfig();
            }
        }
        return true;
    }

    public void applyData(Object data) {
        super.applyData(data);
    }

    @Nullable
    public IAdaptable getElement() {
        return null;
    }

    public void setElement(IAdaptable element) {
    }
}

