/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redis.exec;

import com.dbeaver.db.redis.exec.RedisCommandStatement;
import com.dbeaver.db.redis.exec.RedisEvalStatement;
import com.dbeaver.db.redis.exec.RedisExecutionContext;
import com.dbeaver.db.redis.exec.RedisQueryStatement;
import com.dbeaver.db.redis.model.RedisDataSource;
import com.dbeaver.ee.model.NoSQLConstants;
import java.util.Locale;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.impl.AbstractSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import redis.clients.jedis.Jedis;

public class RedisSession
extends AbstractSession {
    private static final Log log = Log.getLog(RedisSession.class);
    private static final boolean PROCESS_ALL_COMMANDS = true;
    public static final Pattern SELECT_DB_PATTERN = Pattern.compile("\\s*select [0-9]+\\s*", 34);
    private final RedisExecutionContext executionContext;
    private final Object jedisClient;

    public RedisSession(DBRProgressMonitor monitor, DBCExecutionPurpose purpose, String taskTitle, RedisExecutionContext executionContext) {
        super(monitor, purpose, taskTitle);
        this.executionContext = executionContext;
        this.jedisClient = ((RedisDataSource)this.executionContext.getDataSource()).acquireClient();
    }

    @NotNull
    public RedisExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @NotNull
    public RedisDataSource getDataSource() {
        return (RedisDataSource)this.executionContext.getDataSource();
    }

    public Object getJedisClient() {
        return this.jedisClient;
    }

    @NotNull
    public DBCStatement prepareStatement(@NotNull DBCStatementType type, @NotNull String query, boolean scrollable, boolean updatable, boolean returnGeneratedKeys) {
        if (NoSQLConstants.SQL_PATTERN.matcher(query = query.trim()).matches() && !SELECT_DB_PATTERN.matcher(query).matches()) {
            return new RedisQueryStatement(this, query);
        }
        if (query.startsWith("{") || query.toUpperCase(Locale.ENGLISH).startsWith("BEGIN")) {
            query = query.startsWith("{") ? query.substring(1, query.length() - 1) : query.substring("BEGIN".length(), query.length() - "END".length()).trim();
            return new RedisEvalStatement(this, query);
        }
        String[] command = ((RedisDataSource)this.executionContext.getDataSource()).parseCommand(query);
        return new RedisCommandStatement(this, command);
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        throw new DBException("Redis session cancel not implemented");
    }

    public void close() {
        if (this.jedisClient instanceof Jedis) {
            ((Jedis)this.jedisClient).close();
        }
        super.close();
    }

    @NotNull
    public boolean supportsCommands(Class<?> cmdClass) {
        return cmdClass.isInstance(this.jedisClient);
    }

    @NotNull
    public <T> T getCommands(Class<T> cmdClass) {
        try {
            return cmdClass.cast(this.jedisClient);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Redis client " + this.jedisClient + " doesn't supprot commands " + cmdClass.getName());
        }
    }
}

