/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redis.exec;

import com.dbeaver.db.redis.RedisUtils;
import com.dbeaver.db.redis.exec.RedisBaseResultSet;
import com.dbeaver.db.redis.exec.RedisBaseStatement;
import com.dbeaver.db.redis.exec.RedisResultSetSimple;
import com.dbeaver.db.redis.exec.RedisSession;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import redis.clients.jedis.commands.JedisClusterScriptingCommands;
import redis.clients.jedis.commands.ScriptingCommands;

public class RedisQueryStatement
extends RedisBaseStatement {
    protected Object result;

    public RedisQueryStatement(RedisSession session, String query) {
        super(session, query, 0L, 0L);
    }

    public boolean executeStatement() throws DBCException {
        if (this.session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        try {
            RedisUtils.selectCurDatabase(this.getSession());
            if (this.getSession().supportsCommands(ScriptingCommands.class)) {
                ScriptingCommands jedis = this.getSession().getCommands(ScriptingCommands.class);
                this.result = jedis.eval(this.getQueryString());
            } else {
                this.result = this.getSession().getCommands(JedisClusterScriptingCommands.class).eval(this.getQueryString(), this.getClusterSampleKey());
            }
            boolean bl = this.result != null;
            return bl;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            if (this.session.isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, -1L, this.executeError);
            }
        }
    }

    public RedisBaseResultSet openResultSet() throws DBCException {
        if (this.result == null) {
            return null;
        }
        return new RedisResultSetSimple(this, this.result, this.offset);
    }
}

