/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.beans.Transient;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model.ReportFormatType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCredentialReportResponse
extends IamResponse
implements ToCopyableBuilder<Builder, GetCredentialReportResponse> {
    private static final SdkField<SdkBytes> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Content").getter(GetCredentialReportResponse.getter(GetCredentialReportResponse::content)).setter(GetCredentialReportResponse.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<String> REPORT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportFormat").getter(GetCredentialReportResponse.getter(GetCredentialReportResponse::reportFormatAsString)).setter(GetCredentialReportResponse.setter(Builder::reportFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportFormat").build()}).build();
    private static final SdkField<Instant> GENERATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("GeneratedTime").getter(GetCredentialReportResponse.getter(GetCredentialReportResponse::generatedTime)).setter(GetCredentialReportResponse.setter(Builder::generatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD, REPORT_FORMAT_FIELD, GENERATED_TIME_FIELD));
    private final SdkBytes content;
    private final String reportFormat;
    private final Instant generatedTime;

    private GetCredentialReportResponse(BuilderImpl builder) {
        super(builder);
        this.content = builder.content;
        this.reportFormat = builder.reportFormat;
        this.generatedTime = builder.generatedTime;
    }

    public final SdkBytes content() {
        return this.content;
    }

    public final ReportFormatType reportFormat() {
        return ReportFormatType.fromValue(this.reportFormat);
    }

    public final String reportFormatAsString() {
        return this.reportFormat;
    }

    public final Instant generatedTime() {
        return this.generatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCredentialReportResponse)) {
            return false;
        }
        GetCredentialReportResponse other = (GetCredentialReportResponse)((Object)obj);
        return Objects.equals(this.content(), other.content()) && Objects.equals(this.reportFormatAsString(), other.reportFormatAsString()) && Objects.equals(this.generatedTime(), other.generatedTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetCredentialReportResponse").add("Content", (Object)this.content()).add("ReportFormat", (Object)this.reportFormatAsString()).add("GeneratedTime", (Object)this.generatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "ReportFormat": {
                return Optional.ofNullable(clazz.cast(this.reportFormatAsString()));
            }
            case "GeneratedTime": {
                return Optional.ofNullable(clazz.cast(this.generatedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCredentialReportResponse, T> g) {
        return obj -> g.apply((GetCredentialReportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private SdkBytes content;
        private String reportFormat;
        private Instant generatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCredentialReportResponse model) {
            super(model);
            this.content(model.content);
            this.reportFormat(model.reportFormat);
            this.generatedTime(model.generatedTime);
        }

        public final ByteBuffer getContent() {
            return this.content == null ? null : this.content.asByteBuffer();
        }

        public final void setContent(ByteBuffer content) {
            this.content(content == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)content));
        }

        @Override
        @Transient
        public final Builder content(SdkBytes content) {
            this.content = content;
            return this;
        }

        public final String getReportFormat() {
            return this.reportFormat;
        }

        public final void setReportFormat(String reportFormat) {
            this.reportFormat = reportFormat;
        }

        @Override
        @Transient
        public final Builder reportFormat(String reportFormat) {
            this.reportFormat = reportFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder reportFormat(ReportFormatType reportFormat) {
            this.reportFormat(reportFormat == null ? null : reportFormat.toString());
            return this;
        }

        public final Instant getGeneratedTime() {
            return this.generatedTime;
        }

        public final void setGeneratedTime(Instant generatedTime) {
            this.generatedTime = generatedTime;
        }

        @Override
        @Transient
        public final Builder generatedTime(Instant generatedTime) {
            this.generatedTime = generatedTime;
            return this;
        }

        @Override
        public GetCredentialReportResponse build() {
            return new GetCredentialReportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCredentialReportResponse> {
        public Builder content(SdkBytes var1);

        public Builder reportFormat(String var1);

        public Builder reportFormat(ReportFormatType var1);

        public Builder generatedTime(Instant var1);
    }
}

