/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.nativetool;

import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolSettings;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractImportExportSettings<BASE_OBJECT extends DBSObject>
extends AbstractNativeToolSettings<BASE_OBJECT> {
    private static final Log log = Log.getLog(AbstractImportExportSettings.class);
    private String outputFolderPattern;
    private String outputFilePattern;

    public String getOutputFolderPattern() {
        return this.outputFolderPattern;
    }

    public void setOutputFolderPattern(String outputFolderPattern) {
        this.outputFolderPattern = outputFolderPattern;
    }

    public String getOutputFilePattern() {
        return this.outputFilePattern;
    }

    public void setOutputFilePattern(String outputFilePattern) {
        this.outputFilePattern = outputFilePattern;
    }

    public void fillExportObjectsFromInput() {
    }

    @Override
    public void loadSettings(DBRRunnableContext runnableContext, DBPPreferenceStore store) throws DBException {
        super.loadSettings(runnableContext, store);
        this.outputFilePattern = store.getString("export.outputFilePattern");
        if (CommonUtils.isEmpty((String)this.outputFilePattern)) {
            this.outputFilePattern = "dump-${database}-${timestamp}.sql";
        }
        this.outputFolderPattern = CommonUtils.toString((Object)store.getString("export.outputFolder"));
    }

    @Override
    public void saveSettings(DBRRunnableContext runnableContext, DBPPreferenceStore preferenceStore) {
        super.saveSettings(runnableContext, preferenceStore);
        preferenceStore.setValue("export.outputFilePattern", this.outputFilePattern);
        preferenceStore.setValue("export.outputFolder", this.outputFolderPattern);
    }
}

