/*
 * Decompiled with CFR 0.152.
 */
package org.carlspring.cloud.storage.s3fs;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.carlspring.cloud.storage.s3fs.S3FileStore;
import org.carlspring.cloud.storage.s3fs.S3FileSystem;
import org.carlspring.cloud.storage.s3fs.S3Path;
import org.carlspring.cloud.storage.s3fs.util.S3Utils;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.S3Object;

public class S3Iterator
implements Iterator<Path> {
    public static final String ROOT_PATH = "/";
    private final S3FileSystem fileSystem;
    private final S3FileStore fileStore;
    private final String key;
    private final List<S3Path> items = Lists.newArrayList();
    private final Set<S3Path> addedVirtualDirectories = Sets.newHashSet();
    private ListObjectsV2Response current;
    private int cursor;
    private int size;
    private final boolean incremental;
    private final S3Utils s3Utils = new S3Utils();

    public S3Iterator(S3Path path) {
        this(path, false);
    }

    public S3Iterator(S3Path path, boolean incremental) {
        this(path.getFileStore(), String.valueOf(path.getKey()) + (!incremental && !path.getKey().isEmpty() && !path.getKey().endsWith(ROOT_PATH) ? ROOT_PATH : ""), incremental);
    }

    public S3Iterator(S3FileStore fileStore, String key, boolean incremental) {
        ListObjectsV2Request listObjectsV2Request = this.buildRequest(fileStore.name(), key, incremental);
        this.fileStore = fileStore;
        this.fileSystem = fileStore.getFileSystem();
        this.key = key;
        this.current = this.fileSystem.getClient().listObjectsV2(listObjectsV2Request);
        this.incremental = incremental;
        this.loadObjects();
    }

    @Override
    public boolean hasNext() {
        return this.cursor != this.size || this.current.isTruncated() != false;
    }

    @Override
    public S3Path next() {
        if (this.cursor == this.size && this.current.isTruncated().booleanValue()) {
            ListObjectsV2Request request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.fileStore.name()).prefix(this.key).continuationToken(this.current.nextContinuationToken()).build();
            S3Client client = this.fileSystem.getClient();
            this.current = client.listObjectsV2(request);
            this.loadObjects();
        }
        if (this.cursor == this.size) {
            throw new NoSuchElementException();
        }
        return this.items.get(this.cursor++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void loadObjects() {
        this.items.clear();
        if (this.incremental) {
            this.parseObjects();
        } else {
            this.parseObjectListing(this.key, this.items, this.current);
        }
        this.size = this.items.size();
        this.cursor = 0;
    }

    private void parseObjects() {
        for (S3Object object : this.current.contents()) {
            String objectKey = object.key();
            String[] keyParts = this.fileSystem.key2Parts(objectKey);
            this.addParentPaths(keyParts);
            S3Path path = new S3Path(this.fileSystem, object, ROOT_PATH + this.fileStore.name(), keyParts);
            if (this.items.contains(path)) continue;
            this.items.add(path);
        }
    }

    private void addParentPaths(String[] keyParts) {
        if (keyParts.length <= 1) {
            return;
        }
        String[] subParts = Arrays.copyOf(keyParts, keyParts.length - 1);
        ArrayList<S3Path> parentPaths = new ArrayList<S3Path>();
        while (subParts.length > 0) {
            S3Path path = new S3Path(this.fileSystem, ROOT_PATH + this.fileStore.name(), subParts);
            String prefix = this.current.prefix();
            String parentKey = path.getKey();
            if (prefix.length() > parentKey.length() && prefix.contains(parentKey)) break;
            if (this.items.contains(path) || this.addedVirtualDirectories.contains(path)) {
                subParts = Arrays.copyOf(subParts, subParts.length - 1);
                continue;
            }
            parentPaths.add(path);
            this.addedVirtualDirectories.add(path);
            subParts = Arrays.copyOf(subParts, subParts.length - 1);
        }
        Collections.reverse(parentPaths);
        this.items.addAll(parentPaths);
    }

    private void parseObjectListing(String key, List<S3Path> listPath, ListObjectsV2Response current) {
        for (CommonPrefix commonPrefix : current.commonPrefixes()) {
            if (commonPrefix.prefix().equals(ROOT_PATH)) continue;
            String dirKey = commonPrefix.prefix();
            S3Object dir = (S3Object)S3Object.builder().key(dirKey).build();
            listPath.add(new S3Path(this.fileSystem, dir, ROOT_PATH + this.fileStore.name(), this.fileSystem.key2Parts(commonPrefix.prefix())));
        }
        for (S3Object object : current.contents()) {
            String objectKey = object.key();
            String immediateDescendantKey = this.getImmediateDescendant(key, objectKey);
            if (immediateDescendantKey == null) continue;
            S3Path descendentPart = new S3Path(this.fileSystem, object, ROOT_PATH + this.fileStore.name(), this.fileSystem.key2Parts(immediateDescendantKey));
            descendentPart.setFileAttributes(this.s3Utils.toS3FileAttributes(object, descendentPart.getKey()));
            if (listPath.contains(descendentPart)) continue;
            listPath.add(descendentPart);
        }
    }

    private String getImmediateDescendant(String keyParent, String keyChild) {
        int parentLen;
        keyParent = this.deleteExtraPath(keyParent);
        String childWithoutParent = this.deleteExtraPath((keyChild = this.deleteExtraPath(keyChild)).substring(parentLen = keyParent.length()));
        String[] parts = childWithoutParent.split(ROOT_PATH);
        if (parts.length > 0 && !parts[0].isEmpty()) {
            return String.valueOf(keyParent) + ROOT_PATH + parts[0];
        }
        return null;
    }

    private String deleteExtraPath(String keyChild) {
        if (keyChild.startsWith(ROOT_PATH)) {
            keyChild = keyChild.substring(1);
        }
        if (keyChild.endsWith(ROOT_PATH)) {
            keyChild = keyChild.substring(0, keyChild.length() - 1);
        }
        return keyChild;
    }

    ListObjectsV2Request buildRequest(String bucketName, String key, boolean incremental) {
        return this.buildRequest(bucketName, key, incremental, null);
    }

    ListObjectsV2Request buildRequest(String bucketName, String key, boolean incremental, Integer maxKeys) {
        ListObjectsV2Request.Builder builder = ListObjectsV2Request.builder();
        builder.bucket(bucketName);
        if (!CommonUtils.isEmpty((String)key)) {
            builder.prefix(key);
        }
        if (maxKeys != null) {
            builder.maxKeys(maxKeys);
        }
        if (!incremental) {
            builder.delimiter(ROOT_PATH);
        }
        return (ListObjectsV2Request)builder.build();
    }
}

