/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.s3;

import com.dbeaver.cloud.aws.AWSCloud;
import com.dbeaver.cloud.aws.AWSCloudSession;
import com.dbeaver.cloud.aws.s3.AWSFileSystemS3Bucket;
import com.dbeaver.net.auth.aws.AuthModelAWSCredentials;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystem;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.Bucket;

public class AWSFileSystemS3
implements DBFVirtualFileSystem {
    private AWSCloud cloud;
    private SMSessionContext sessionContext;
    private S3Client globalS3Client;

    public AWSFileSystemS3(AWSCloud cloud, SMSessionContext sessionContext) {
        this.cloud = cloud;
        this.sessionContext = sessionContext;
    }

    public SMSessionContext getSessionContext() {
        return this.sessionContext;
    }

    @NotNull
    public String getFileSystemDisplayName() {
        return "S3 " + this.cloud.getCloudConfiguration().getCloudName();
    }

    @NotNull
    public String getType() {
        return "s3";
    }

    public String getDescription() {
        return "S3 file system for " + this.cloud.getName();
    }

    public DBPImage getIcon() {
        return null;
    }

    @NotNull
    public String getId() {
        return this.cloud.getCloudId();
    }

    public AWSCloud getCloud() {
        return this.cloud;
    }

    S3Client getGlobalS3Client(DBRProgressMonitor monitor) throws DBException {
        if (this.globalS3Client == null) {
            this.globalS3Client = this.getS3Client(monitor, Region.US_EAST_2);
        }
        return this.globalS3Client;
    }

    S3Client getS3Client(DBRProgressMonitor monitor, Region region) throws DBException {
        SMSession spaceSession = this.sessionContext.getSpaceSession(monitor, (SMAuthSpace)this.cloud, true);
        if (!(spaceSession instanceof AWSCloudSession)) {
            throw new DBException("Can't obtain AWS cloud session from context");
        }
        AuthModelAWSCredentials iamCredentials = ((AWSCloudSession)spaceSession).getIamCredentials();
        AwsCredentialsProvider credentialsProvider = iamCredentials.getAuthCredentialsProvider(monitor);
        S3ClientBuilder s3ClientBuilder = (S3ClientBuilder)S3Client.builder().credentialsProvider(credentialsProvider);
        if (region != null) {
            s3ClientBuilder.region(region);
        }
        return (S3Client)s3ClientBuilder.build();
    }

    @NotNull
    public AWSFileSystemS3Bucket[] getRootFolders(DBRProgressMonitor monitor) throws DBException {
        S3Client s3Client = this.getGlobalS3Client(monitor);
        try {
            return (AWSFileSystemS3Bucket[])s3Client.listBuckets().buckets().stream().map(bucket -> new AWSFileSystemS3Bucket(this, (Bucket)bucket)).toArray(AWSFileSystemS3Bucket[]::new);
        }
        catch (Exception e) {
            throw new DBException("Error initializing S3 file system", (Throwable)e);
        }
    }
}

