/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.debug.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.text.BaseTextDocumentProvider;

public class DatabaseScriptEditor
extends SQLEditorBase {
    protected static final Log log = Log.getLog(DatabaseScriptEditor.class);
    private final DBCExecutionContext executionContext;

    public DatabaseScriptEditor(DBSObject dbsObject, final String title) {
        DBCExecutionContext isolatedContext = null;
        try {
            isolatedContext = DBUtils.getObjectOwnerInstance((DBSObject)dbsObject).openIsolatedContext((DBRProgressMonitor)new VoidProgressMonitor(), title, null);
        }
        catch (DBException e) {
            String message = NLS.bind((String)"Unable to open execution context for {0}", (Object)dbsObject);
            log.error((Object)message, (Throwable)e);
        }
        this.executionContext = isolatedContext;
        this.setDocumentProvider((IDocumentProvider)new BaseTextDocumentProvider(){

            protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
            }

            protected IDocument createDocument(Object element) throws CoreException {
                Document document = new Document();
                if (element instanceof StringEditorInput) {
                    StringEditorInput stringInput = (StringEditorInput)element;
                    StringBuilder buffer = stringInput.getBuffer();
                    document.set(buffer.toString());
                } else {
                    document.set(title);
                }
                return document;
            }

            public boolean isReadOnly(Object element) {
                return false;
            }

            public boolean isModifiable(Object element) {
                return true;
            }
        });
    }

    public DBCExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public void dispose() {
        if (this.executionContext != null) {
            this.executionContext.close();
        }
        super.dispose();
    }
}

